/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.coremod;

import alexiil.mods.lib.AlexIILLibLog;
import alexiil.mods.lib.debug.DebugLog;
import alexiil.mods.lib.debug.LoggingPositions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LogHelperTransformer
implements Opcodes {
    private static final Multimap<String, LoggingPositions> annotationTypeMap = ArrayListMultimap.create();
    private static final List<String> whitelist = Lists.newArrayList();
    private static final Map<Integer, Integer> ifBytecodes = Maps.newHashMap();
    private static final Map<Integer, Boolean> ifByteType = Maps.newHashMap();

    public static void addToWhitelist(String packageBase) {
        whitelist.add(packageBase);
    }

    public static void addType(int opcode, int stackSize, boolean isObject) {
        ifBytecodes.put(opcode, stackSize);
        ifByteType.put(opcode, isObject);
    }

    public static boolean isIfObject(int opcode) {
        return ifByteType.get(opcode);
    }

    public static byte[] transform(String name, byte[] data) {
        if (name == null) {
            return data;
        }
        boolean can = false;
        for (String white : whitelist) {
            if (!name.startsWith(white)) continue;
            can = true;
            break;
        }
        if (!can) {
            return data;
        }
        try {
            ClassNode classNode = new ClassNode();
            ClassReader reader = new ClassReader(data);
            reader.accept((ClassVisitor)classNode, 0);
            List<LoggingPositions> shouldDebug = LogHelperTransformer.shouldDebug(classNode.visibleAnnotations);
            boolean hasChanged = false;
            for (MethodNode node : classNode.methods) {
                String blsLogName = Type.getInternalName(AlexIILLibLog.class);
                List<LoggingPositions> actual = LogHelperTransformer.shouldDebug(node.visibleAnnotations);
                if ((actual = LogHelperTransformer.combine(shouldDebug, actual)).contains((Object)LoggingPositions.INVOKE)) {
                    LogHelperTransformer.insertInvoke(node);
                    hasChanged = true;
                } else if (!actual.isEmpty()) {
                    node.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, blsLogName, "justInvoke", "()V", false));
                    hasChanged = true;
                }
                if (actual.contains((Object)LoggingPositions.RETURN)) {
                    for (AbstractInsnNode ret : LogHelperTransformer.getReturnNodes(node)) {
                        LogHelperTransformer.insertReturn(node, ret);
                    }
                    hasChanged = true;
                } else if (!actual.isEmpty()) {
                    for (AbstractInsnNode ret : LogHelperTransformer.getReturnNodes(node)) {
                        MethodInsnNode justReturn = new MethodInsnNode(184, blsLogName, "justReturn", "()V", false);
                        node.instructions.insertBefore(ret, (AbstractInsnNode)justReturn);
                    }
                    hasChanged = true;
                }
                if (!actual.contains((Object)LoggingPositions.LOGIC_SPLIT)) continue;
                for (AbstractInsnNode ifNode : LogHelperTransformer.getIfNodes(node)) {
                    LogHelperTransformer.insertIf(node, ifNode);
                }
                hasChanged = true;
            }
            ClassWriter cw = new ClassWriter(1);
            classNode.accept((ClassVisitor)cw);
            byte[] bytes = cw.toByteArray();
            if (hasChanged) {
                File folder = new File("./bls-asm");
                folder.mkdir();
                folder = new File(folder, "/logging");
                folder.mkdir();
                File fle = new File(folder, name + ".class");
                try {
                    FileOutputStream stream = new FileOutputStream(fle);
                    stream.write(bytes);
                    stream.flush();
                    stream.close();
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
            return bytes;
        }
        catch (Throwable t) {
            AlexIILLibLog.warn("An exception occoured while transforming " + name + "!", t);
            return data;
        }
    }

    private static List<LoggingPositions> shouldDebug(List<AnnotationNode> annotations) {
        ArrayList list = Lists.newArrayList();
        if (annotations != null) {
            for (AnnotationNode annotation : annotations) {
                for (Map.Entry entry : annotationTypeMap.asMap().entrySet()) {
                    if (!((String)entry.getKey()).equals(annotation.desc)) continue;
                    list.addAll((Collection)entry.getValue());
                }
            }
        }
        return list;
    }

    private static List<LoggingPositions> combine(List<LoggingPositions> clazz, List<LoggingPositions> method) {
        if (method.contains((Object)LoggingPositions.IGNORE_PARENT)) {
            return method;
        }
        for (LoggingPositions entry : clazz) {
            if (method.contains((Object)entry)) continue;
            method.add(entry);
        }
        return method;
    }

    private static void insertInvoke(MethodNode node) {
        Type[] args = Type.getArgumentTypes((String)node.desc);
        int length = (Type.getArgumentsAndReturnSizes((String)node.desc) >> 2) - 1;
        int lowestLocal = 0;
        if ((node.access / 8 & 1) == 0) {
            lowestLocal = 1;
            ++length;
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new LdcInsnNode((Object)args.length));
        list.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Object.class)));
        int arrayIndex = args.length - 1;
        int localsIndex = length - 1;
        while (localsIndex >= lowestLocal) {
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new LdcInsnNode((Object)arrayIndex));
            localsIndex -= LogHelperTransformer.insertCastToObject(list, localsIndex, args[arrayIndex]);
            list.add((AbstractInsnNode)new InsnNode(83));
            --arrayIndex;
        }
        list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(AlexIILLibLog.class), "logInvoke", "([Ljava/lang/Object;)V", false));
        node.instructions.insert(list);
    }

    private static List<AbstractInsnNode> getReturnNodes(MethodNode node) {
        ArrayList nodes = Lists.newArrayList();
        for (int index = 0; index < node.instructions.size(); ++index) {
            AbstractInsnNode potential = node.instructions.get(index);
            if (potential.getOpcode() < 172 || potential.getOpcode() > 177) continue;
            nodes.add(potential);
        }
        return nodes;
    }

    private static void insertReturn(MethodNode meth, AbstractInsnNode node) {
        Type ret = Type.getReturnType((String)meth.desc);
        InsnList list = new InsnList();
        String text = "()V";
        if (node.getOpcode() != 177) {
            list.add((AbstractInsnNode)new InsnNode(89));
            LogHelperTransformer.insertCastToObject(list, -1, ret);
            text = "(Ljava/lang/Object;)V";
        }
        list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(AlexIILLibLog.class), "logReturn", text, false));
        meth.instructions.insertBefore(node, list);
    }

    private static List<AbstractInsnNode> getIfNodes(MethodNode node) {
        ArrayList nodes = Lists.newArrayList();
        for (int index = 0; index < node.instructions.size(); ++index) {
            AbstractInsnNode potential = node.instructions.get(index);
            if (!ifBytecodes.containsKey(potential.getOpcode())) continue;
            nodes.add(potential);
        }
        return nodes;
    }

    private static void insertIf(MethodNode meth, AbstractInsnNode node) {
        InsnList list = new InsnList();
        int opcode = node.getOpcode();
        int arguments = ifBytecodes.get(opcode);
        boolean isObject = ifByteType.get(opcode);
        if (arguments == 1) {
            list.add((AbstractInsnNode)new InsnNode(89));
            if (isObject) {
                list.add((AbstractInsnNode)new InsnNode(1));
            } else {
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Integer.class), "valueOf", "(I)Ljava/lang/Integer;", false));
                list.add((AbstractInsnNode)new LdcInsnNode((Object)0));
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Integer.class), "valueOf", "(I)Ljava/lang/Integer;", false));
            }
        } else if (isObject) {
            list.add((AbstractInsnNode)new InsnNode(92));
        } else {
            list.add((AbstractInsnNode)new InsnNode(92));
            list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Integer.class), "valueOf", "(I)Ljava/lang/Integer;", false));
            list.add((AbstractInsnNode)new InsnNode(95));
            list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Integer.class), "valueOf", "(I)Ljava/lang/Integer;", false));
            list.add((AbstractInsnNode)new InsnNode(95));
        }
        list.add((AbstractInsnNode)new LdcInsnNode((Object)opcode));
        String text = "(Ljava/lang/Object;Ljava/lang/Object;I)V";
        list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(AlexIILLibLog.class), "logIf", text, false));
        meth.instructions.insertBefore(node, list);
    }

    private static int insertCastToObject(InsnList list, int index, Type type) {
        switch (type.getSort()) {
            case 1: {
                if (index >= 0) {
                    list.add((AbstractInsnNode)new VarInsnNode(21, index));
                }
                list.add((AbstractInsnNode)new InsnNode(145));
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Boolean.class), "valueOf", "(Z)Ljava/lang/Boolean;", false));
                break;
            }
            case 3: {
                if (index >= 0) {
                    list.add((AbstractInsnNode)new VarInsnNode(21, index));
                }
                list.add((AbstractInsnNode)new InsnNode(145));
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Byte.class), "valueOf", "(B)Ljava/lang/Byte;", false));
                break;
            }
            case 2: {
                if (index >= 0) {
                    list.add((AbstractInsnNode)new VarInsnNode(21, index));
                }
                list.add((AbstractInsnNode)new InsnNode(146));
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Character.class), "valueOf", "(C)Ljava/lang/Character;", false));
                break;
            }
            case 8: {
                if (index >= 0) {
                    list.add((AbstractInsnNode)new VarInsnNode(24, index - 1));
                }
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Double.class), "valueOf", "(D)Ljava/lang/Double;", false));
                return 2;
            }
            case 6: {
                if (index >= 0) {
                    list.add((AbstractInsnNode)new VarInsnNode(23, index));
                }
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Float.class), "valueOf", "(F)Ljava/lang/Float;", false));
                break;
            }
            case 5: {
                if (index >= 0) {
                    list.add((AbstractInsnNode)new VarInsnNode(21, index));
                }
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Integer.class), "valueOf", "(I)Ljava/lang/Integer;", false));
                break;
            }
            case 7: {
                if (index >= 0) {
                    list.add((AbstractInsnNode)new VarInsnNode(22, index - 1));
                }
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Long.class), "valueOf", "(J)Ljava/lang/Long;", false));
                return 2;
            }
            case 4: {
                if (index >= 0) {
                    list.add((AbstractInsnNode)new VarInsnNode(21, index));
                }
                list.add((AbstractInsnNode)new InsnNode(147));
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Short.class), "valueOf", "(S)Ljava/lang/Short;", false));
                break;
            }
            default: {
                if (index < 0) break;
                list.add((AbstractInsnNode)new VarInsnNode(25, index));
            }
        }
        return 1;
    }

    static {
        annotationTypeMap.put((Object)Type.getDescriptor(DebugLog.class), (Object)LoggingPositions.INVOKE);
        annotationTypeMap.put((Object)Type.getDescriptor(DebugLog.class), (Object)LoggingPositions.LOGIC_SPLIT);
        annotationTypeMap.put((Object)Type.getDescriptor(DebugLog.class), (Object)LoggingPositions.RETURN);
        annotationTypeMap.put((Object)Type.getDescriptor(DebugLog.Invoke.class), (Object)LoggingPositions.INVOKE);
        annotationTypeMap.put((Object)Type.getDescriptor(DebugLog.LogicSplit.class), (Object)LoggingPositions.LOGIC_SPLIT);
        annotationTypeMap.put((Object)Type.getDescriptor(DebugLog.Return.class), (Object)LoggingPositions.RETURN);
        annotationTypeMap.put((Object)Type.getDescriptor(DebugLog.IgnoreClass.class), (Object)LoggingPositions.IGNORE_PARENT);
        LogHelperTransformer.addToWhitelist("alexiil");
        LogHelperTransformer.addType(165, 2, true);
        LogHelperTransformer.addType(166, 2, true);
        LogHelperTransformer.addType(159, 2, false);
        LogHelperTransformer.addType(162, 2, false);
        LogHelperTransformer.addType(163, 2, false);
        LogHelperTransformer.addType(164, 2, false);
        LogHelperTransformer.addType(161, 2, false);
        LogHelperTransformer.addType(160, 2, false);
        LogHelperTransformer.addType(153, 1, false);
        LogHelperTransformer.addType(156, 1, false);
        LogHelperTransformer.addType(157, 1, false);
        LogHelperTransformer.addType(158, 1, false);
        LogHelperTransformer.addType(155, 1, false);
        LogHelperTransformer.addType(154, 1, false);
        LogHelperTransformer.addType(199, 1, true);
        LogHelperTransformer.addType(198, 1, true);
    }
}

