/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.coremod;

import alexiil.mods.lib.AlexIILLib;
import alexiil.mods.lib.ErrorHandling;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraftforge.common.config.Property;

public class RoamingIPAddress {
    private static Map<String, String> nameToIP = Collections.synchronizedMap(new HashMap());
    public static Property roamingIPLoc = null;

    public static void init() {
        roamingIPLoc = AlexIILLib.instance.cfg.getProp("roamingIP.location", "null");
        if (AlexIILLib.roamingIP.getBoolean()) {
            RoamingIPAddress.loadIPAddresses();
        }
    }

    public static ServerData getModifiedRoamingServerData(ServerData data) {
        String name;
        String port;
        if (!AlexIILLib.roamingIP.getBoolean()) {
            return data;
        }
        if (!data.field_78845_b.startsWith("roaming-")) {
            return data;
        }
        int indexHyphen = data.field_78845_b.indexOf("-");
        if (indexHyphen == -1) {
            return data;
        }
        int indexColon = data.field_78845_b.indexOf(":");
        if (indexColon == -1) {
            port = "25565";
            name = data.field_78845_b.substring(indexHyphen + 1);
        } else {
            port = data.field_78845_b.substring(indexColon + 1);
            name = data.field_78845_b.substring(indexHyphen + 1, indexColon);
        }
        String ip = nameToIP.containsKey(name.intern()) ? nameToIP.get(name.intern()) : "invalid";
        ip = ip + ":" + port;
        ServerData newData = new ServerData(name, ip);
        newData.field_82822_g = data.field_82822_g;
        newData.field_82821_f = data.field_82821_f;
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadIPAddresses() {
        block20: {
            try {
                File ipFile = new File(roamingIPLoc.getString());
                if (ipFile.exists()) {
                    BufferedReader br = null;
                    String line = "";
                    try {
                        br = new BufferedReader(new FileReader(ipFile));
                        line = br.readLine();
                        int lineNo = -1;
                        while (line != null) {
                            ++lineNo;
                            if (line.length() == 0) {
                                AlexIILLib.instance.log.warn("Found an empty line at line #" + lineNo);
                            } else if (!line.contains("=")) {
                                AlexIILLib.instance.log.warn("Did not find an equals sign at line #" + lineNo + ", \"" + line + "\"");
                            } else if (line.indexOf("=") == 0) {
                                AlexIILLib.instance.log.warn("Found an equals sign at the start of the line #" + lineNo + ", \"" + line + "\"");
                            } else if (line.indexOf("=") == line.length() - 1) {
                                AlexIILLib.instance.log.warn("Found an equals sign at the start of the line #" + lineNo + ", \"" + line + "\"");
                            } else if (line.indexOf("=") != line.lastIndexOf("=")) {
                                AlexIILLib.instance.log.warn("Found more than one equals sign in the line #" + lineNo + ", \"" + line + "\"");
                            } else {
                                String[] ip = line.split("=");
                                AlexIILLib.instance.log.info("Added (" + ip[0] + ") -> (" + ip[1] + ")");
                                nameToIP.put(ip[0], ip[1]);
                            }
                            line = br.readLine();
                        }
                        break block20;
                    }
                    catch (Throwable t) {
                        ErrorHandling.printStackTrace(t, "loading the line " + line);
                        break block20;
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                    }
                }
                AlexIILLib.instance.log.warn("IP file did not exist!");
            }
            catch (Throwable t) {
                ErrorHandling.printStackTrace(t, "opening the IP address file");
            }
        }
    }
}

