/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.item;

import alexiil.mods.lib.AlexIILMod;
import alexiil.mods.lib.EChatColours;
import alexiil.mods.lib.item.IChangingItemString;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemBase
extends Item {
    private static final List<ItemBase> items = new ArrayList<ItemBase>();
    private final AlexIILMod mod;
    protected final String name;
    private List<Object> lines = new ArrayList<Object>();
    private List<Object> shiftLines = new ArrayList<Object>();
    private boolean hasShift;
    private boolean hasEffect = false;

    public static void initModels() {
        for (ItemBase ib : items) {
            ib.initModel();
        }
    }

    public ItemBase(String name, AlexIILMod mod) {
        this.mod = mod;
        this.name = name;
        this.func_77655_b(mod.meta.modId + "_" + name);
        Property prop = mod.cfg.cfg().get("items", name, true);
        prop.comment = "Enable the " + mod.format(this.func_77658_a() + ".name", new Object[0]) + " item";
        if (prop.getBoolean()) {
            GameRegistry.registerItem((Item)this, (String)name);
            this.func_77637_a(mod.tab);
            items.add(this);
        }
    }

    public ItemBase setCraftingPart() {
        this.lines.add("Crafting Item.");
        return this;
    }

    public ItemBase setCraftingPart(String item) {
        this.setCraftingPart();
        this.lines.add("Used for the " + item + ".");
        return this;
    }

    public ItemBase addInfo(String line) {
        this.lines.add(line);
        return this;
    }

    public ItemBase addInfo(IChangingItemString line) {
        this.lines.add(line);
        return this;
    }

    public ItemBase addShiftInfo(String line) {
        this.shiftLines.add(line);
        this.hasShift = true;
        return this;
    }

    public ItemBase addShiftInfo(IChangingItemString line) {
        this.shiftLines.add(line);
        this.hasShift = true;
        return this;
    }

    public ItemBase setWorkInProgress() {
        this.lines.add("This is a WIP item!");
        return this;
    }

    public ItemBase setEffect() {
        this.hasEffect = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return this.hasEffect && pass == 0;
    }

    public void initModel() {
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        mesher.func_178086_a((Item)this, 0, new ModelResourceLocation(this.mod.meta.modId + ":" + this.name, "inventory"));
    }

    private boolean isShiftKeyPressed() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public String[] getString(Object o, ItemStack i, EntityPlayer p) {
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof IChangingItemString) {
            return ((IChangingItemString)o).getString(i, p);
        }
        return new String[]{o.toString()};
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        if (this.isShiftKeyPressed() && this.hasShift) {
            for (Object line : this.shiftLines) {
                String[] ls = this.getString(line, itemStack, player);
                if (ls == null) continue;
                for (String l : ls) {
                    if (l == null) continue;
                    list.add(l);
                }
            }
        } else {
            for (Object line : this.lines) {
                String[] ls = this.getString(line, itemStack, player);
                if (ls == null) continue;
                for (String l : ls) {
                    if (l == null) continue;
                    list.add(l);
                }
            }
            if (this.hasShift) {
                list.add("<Hold " + (Object)((Object)EChatColours.BLUE) + "SHIFT" + (Object)((Object)EChatColours.GRAY) + " for more info>");
            }
        }
        super.func_77624_a(itemStack, player, list, flag);
    }
}

