/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.nbt;

import alexiil.mods.lib.AlexIILLib;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;

public class NBTUtils {
    public static final String NBT_STRING_BYTE = "B-";

    public static String toString(NBTTagCompound nbt) {
        return NBTUtils.getNextLine(0) + NBTUtils.toString(nbt, 0);
    }

    public static String toString(NBTTagCompound nbt, int indent) {
        String s = "{";
        int idx = nbt.func_150296_c().size();
        for (Object o : nbt.func_150296_c()) {
            String key = (String)o;
            s = s + NBTUtils.getNextLine(indent + 1);
            s = s + key + ":";
            NBTBase base = nbt.func_74781_a(key);
            s = s + NBTUtils.toString(base, indent + 1);
            if (idx != 1) {
                s = s + ",";
            }
            s = s + NBTUtils.getNextLine(indent);
            --idx;
        }
        return s + NBTUtils.getNextLine(indent) + "}";
    }

    private static String toString(NBTBase base, int indent) {
        String s = "";
        switch (base.func_74732_a()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                s = s + base.toString();
                break;
            }
            case 9: {
                s = s + "<";
                for (int i = 0; i < ((NBTTagList)base).func_74745_c(); ++i) {
                    NBTBase base1 = ((NBTTagList)base).func_179238_g(i);
                    s = s + NBTUtils.getNextLine(indent + 1) + NBTUtils.toString(base1, indent + 1);
                    if (i == ((NBTTagList)base).func_74745_c() - 1) continue;
                    s = s + ",";
                }
                s = s + NBTUtils.getNextLine(indent) + ">";
                break;
            }
            case 10: {
                s = s + NBTUtils.toString((NBTTagCompound)base, indent + 1);
                break;
            }
            case 11: {
                int[] intarr = ((NBTTagIntArray)base).func_150302_c();
                s = s + Arrays.toString(intarr);
            }
        }
        return s;
    }

    private static String getNextLine(int indent) {
        String s = "\n";
        while (indent > 0) {
            s = s + "\t";
            --indent;
        }
        return s;
    }

    public static NBTTagCompound convertToNBT(ConfigCategory cat) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (ConfigCategory child : cat.getChildren()) {
            nbt.func_74782_a(child.getName(), (NBTBase)NBTUtils.convertToNBT(child));
        }
        for (Map.Entry pair : cat.entrySet()) {
            Property prop = (Property)pair.getValue();
            switch (prop.getType()) {
                case BOOLEAN: {
                    Object[] strings;
                    if (prop.isList()) {
                        strings = prop.getStringList();
                        NBTTagList list = new NBTTagList();
                        for (String s : strings) {
                            list.func_74742_a((NBTBase)new NBTTagString(s));
                        }
                        nbt.func_74782_a((String)pair.getKey(), (NBTBase)list);
                        break;
                    }
                    nbt.func_74757_a((String)pair.getKey(), prop.getBoolean());
                    break;
                }
                case DOUBLE: {
                    Object[] strings;
                    if (prop.isList()) {
                        strings = prop.getDoubleList();
                        NBTTagList list = new NBTTagList();
                        for (String s : strings) {
                            list.func_74742_a((NBTBase)new NBTTagDouble((double)s));
                        }
                        nbt.func_74782_a((String)pair.getKey(), (NBTBase)list);
                        break;
                    }
                    nbt.func_74780_a((String)pair.getKey(), prop.getDouble());
                    break;
                }
                case INTEGER: {
                    Object[] strings;
                    if (prop.isList()) {
                        strings = prop.getIntList();
                        NBTTagList list = new NBTTagList();
                        for (String s : strings) {
                            list.func_74742_a((NBTBase)new NBTTagInt((int)s));
                        }
                        nbt.func_74782_a((String)pair.getKey(), (NBTBase)list);
                        break;
                    }
                    nbt.func_74768_a((String)pair.getKey(), prop.getInt());
                    break;
                }
                case STRING: {
                    Object[] strings;
                    if (prop.isList()) {
                        strings = prop.getStringList();
                        NBTTagList list = new NBTTagList();
                        for (String s : strings) {
                            list.func_74742_a((NBTBase)new NBTTagString(s));
                        }
                        nbt.func_74782_a((String)pair.getKey(), (NBTBase)list);
                        break;
                    }
                    String s = prop.getString();
                    if (s.startsWith(NBT_STRING_BYTE)) {
                        byte b = Byte.parseByte(s.substring(NBT_STRING_BYTE.length()));
                        nbt.func_74774_a((String)pair.getKey(), b);
                        break;
                    }
                    nbt.func_74778_a((String)pair.getKey(), s);
                    break;
                }
                default: {
                    AlexIILLib.instance.log.warn("Was an unsupported type! (" + prop.getType().name().toLowerCase() + ")");
                }
            }
        }
        return nbt;
    }

    public static void convertToConfigCategory(ConfigCategory cat, NBTTagCompound nbt) {
        for (Object key : nbt.func_150296_c()) {
            String name = (String)key;
            NBTBase tag = nbt.func_74781_a(name);
            switch (tag.func_74732_a()) {
                case 1: {
                    byte b = ((NBTBase.NBTPrimitive)tag).func_150290_f();
                    cat.put(name, new Property(name, NBT_STRING_BYTE + b, Property.Type.STRING));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    int l = ((NBTBase.NBTPrimitive)tag).func_150287_d();
                    cat.put(name, new Property(name, Integer.toString(l), Property.Type.INTEGER));
                    break;
                }
                case 5: 
                case 6: {
                    double d = ((NBTBase.NBTPrimitive)tag).func_150286_g();
                    cat.put(name, new Property(name, Double.toString(d), Property.Type.DOUBLE));
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    String s = ((NBTTagString)tag).func_150285_a_();
                    cat.put(name, new Property(name, s, Property.Type.STRING));
                    break;
                }
                case 9: {
                    Property.Type type;
                    NBTTagList list = (NBTTagList)tag;
                    String[] strings = new String[list.func_74745_c()];
                    switch (list.func_150303_d()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            type = Property.Type.INTEGER;
                            break;
                        }
                        case 5: 
                        case 6: {
                            type = Property.Type.DOUBLE;
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 11: {
                            type = Property.Type.STRING;
                            break;
                        }
                        case 9: 
                        case 10: {
                            AlexIILLib.instance.log.warn("A tag list was found embedded in a tag list! This cannot be directly transfered to a config category, skipping.");
                        }
                        default: {
                            type = null;
                        }
                    }
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTBase n = list.func_179238_g(i);
                        strings[i] = n instanceof NBTTagString ? ((NBTTagString)n).func_150285_a_() : n.toString();
                    }
                    if (type == null) break;
                    cat.put(name, new Property(name, strings, type));
                    break;
                }
                case 10: {
                    ConfigCategory cat2 = null;
                    for (ConfigCategory child : cat.getChildren()) {
                        if (!child.getName().equals(name)) continue;
                        cat2 = child;
                    }
                    if (cat2 == null) {
                        cat2 = new ConfigCategory(name, cat);
                    }
                    NBTUtils.convertToConfigCategory(cat2, (NBTTagCompound)tag);
                }
            }
        }
    }
}

