/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.net;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public abstract class MessageBase<M extends MessageBase<?>>
implements IMessage,
IMessageHandler<M, IMessage> {
    protected NBTTagCompound readNBT(ByteBuf buf) {
        int len = buf.readInt();
        if (len <= 0) {
            return null;
        }
        byte[] bytes = buf.readBytes(len).array();
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ByteBuf writeNBT(NBTTagCompound nbt, ByteBuf buf) {
        byte[] bytes;
        if (nbt == null) {
            buf.writeInt(-1);
            return buf;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)baos);
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return buf;
        }
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
        return buf;
    }
}

