/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LoadingFrame
extends JFrame {
    private JPanel contentPane;
    private JLabel lblState;
    private JProgressBar progressBar;
    private ThreadIncrementer incrementer;

    public static LoadingFrame openWindow() {
        String clsName = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(clsName);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            LoadingFrame frame = new LoadingFrame();
            frame.setBounds(LoadingFrame.getWindowBounds(frame));
            frame.setAlwaysOnTop(true);
            frame.setVisible(true);
            return frame;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Rectangle getWindowBounds(LoadingFrame frame) {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = frame.getBounds();
        return new Rectangle((size.width - bounds.width) / 2, (size.height - bounds.height) / 2, bounds.width, bounds.height);
    }

    public LoadingFrame() {
        this.setTitle("Minecraft Loading");
        this.setDefaultCloseOperation(0);
        this.setBounds(100, 100, 450, 85);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "North");
        panel.setLayout(new BorderLayout(0, 0));
        this.lblState = new JLabel("State");
        panel.add((Component)this.lblState, "North");
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        panel_1.add((Component)this.progressBar, "North");
    }

    public void setMessage(String message) {
        this.lblState.setText(message);
    }

    public void setProgress(double percent) {
        this.progressBar.setValue((int)percent);
    }

    public void setProgressIncrementing(float from, float to, long howLongFor) {
        if (this.incrementer != null) {
            this.incrementer.stopIncrementing();
        }
        this.incrementer = new ThreadIncrementer(from, to, howLongFor);
        this.incrementer.start();
    }

    private class ThreadIncrementer
    extends Thread {
        private final AtomicBoolean shouldIncrement = new AtomicBoolean(true);
        private final float from;
        private final float to;
        private final float diff;
        private final long time;
        private long timeLeft;

        public ThreadIncrementer(float from, float to, long timeLeft) {
            this.from = from;
            this.to = to;
            this.diff = to - from;
            this.timeLeft = timeLeft;
            this.time = timeLeft;
        }

        public void stopIncrementing() {
            this.shouldIncrement.set(false);
            LoadingFrame.this.incrementer = null;
        }

        @Override
        public void run() {
            while (this.timeLeft > 0L && this.shouldIncrement.get()) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
                this.timeLeft -= 250L;
                long timeDiff = this.time - this.timeLeft;
                double percent = (double)timeDiff / (double)this.time;
                LoadingFrame.this.setProgress((double)this.from + percent * (double)this.diff);
                LoadingFrame.this.repaint();
            }
            if (LoadingFrame.this.incrementer == this) {
                LoadingFrame.this.incrementer = null;
            }
        }
    }
}

