/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.json;

import alexiil.mods.load.json.Area;
import alexiil.mods.load.json.EPosition;
import alexiil.mods.load.json.EType;

public class ImageRender {
    public final String resourceLocation;
    public final EPosition positionType;
    public final EType type;
    public final Area texture;
    public final Area position;
    public final String colour;
    public final String text;

    public ImageRender(String resourceLocation, EPosition positionType, EType type, Area texture, Area position, String colour, String text) {
        this.resourceLocation = resourceLocation;
        this.positionType = positionType;
        this.type = type;
        this.texture = texture;
        this.position = position;
        this.colour = colour;
        this.text = text;
    }

    public ImageRender(String resourceLocation, EPosition positionType, EType type, Area texture, Area position) {
        this(resourceLocation, positionType, type, texture, position, null, null);
    }

    public int transformX(int screenWidth) {
        return this.positionType.transformX(this.position.x, screenWidth - this.position.width);
    }

    public int transformY(int screenWidth) {
        return this.positionType.transformY(this.position.y, screenWidth - this.position.height);
    }

    public int getColour() {
        if (this.colour == null) {
            return 0xFFFFFF;
        }
        try {
            return Integer.parseInt(this.colour, 16);
        }
        catch (NumberFormatException nfe) {
            return 0xFFFFFF;
        }
    }

    private float getColourPart(int bitStart) {
        return (float)(this.getColour() >> bitStart & 0xFF) / 256.0f;
    }

    public float getRed() {
        return this.getColourPart(16);
    }

    public float getGreen() {
        return this.getColourPart(8);
    }

    public float getBlue() {
        return this.getColourPart(0);
    }
}

