/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import alexiil.mods.load.ProgressDisplayer;
import alexiil.mods.load.json.Area;
import alexiil.mods.load.json.EPosition;
import alexiil.mods.load.json.EType;
import alexiil.mods.load.json.ImageRender;
import alexiil.mods.load.json.JsonConfig;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;

public class MinecraftDisplayer
implements ProgressDisplayer.IDisplayer {
    private static String sound;
    private static String defaultSound;
    private ImageRender[] images;
    private TextureManager textureManager = null;
    private Map<String, FontRenderer> fontRenderers = new HashMap<String, FontRenderer>();
    private FontRenderer fontRenderer = null;
    private ScaledResolution resolution = null;
    private Minecraft mc = null;
    private boolean callAgain = false;
    private boolean isOpen = true;
    private String lastText;
    private double lastPercent;
    private IResourcePack myPack;

    public static void playFinishedSound() {
        ResourceLocation location;
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        SoundEventAccessorComposite snd = soundHandler.func_147680_a(location = new ResourceLocation(sound));
        if (snd == null) {
            System.out.println("The sound given (" + sound + ") did not give a valid sound!");
            location = new ResourceLocation(defaultSound);
            snd = soundHandler.func_147680_a(location);
        }
        if (snd == null) {
            System.out.println("Default sound did not give a valid sound!");
            return;
        }
        PositionedSoundRecord sound = PositionedSoundRecord.func_147673_a((ResourceLocation)location);
        soundHandler.func_147682_a((ISound)sound);
    }

    private List<IResourcePack> getOnlyList() {
        Field[] flds;
        for (Field f : flds = this.mc.getClass().getDeclaredFields()) {
            if (!f.getType().equals(List.class) || Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                return (List)f.get(this.mc);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void open(Configuration cfg) {
        this.mc = Minecraft.func_71410_x();
        String comment4 = "What sound to play when loading is complete. Default is the level up sound (" + defaultSound + ")";
        sound = cfg.getString("sound", "general", defaultSound, comment4);
        this.myPack = !ProgressDisplayer.coreModLocation.isDirectory() ? new FMLFileResourcePack(ProgressDisplayer.modContainer) : new FMLFolderResourcePack(ProgressDisplayer.modContainer);
        this.getOnlyList().add(this.myPack);
        this.mc.func_110436_a();
        File configDir = new File("./config/BetterLoadingScreen");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        this.images = new ImageRender[5];
        String progress = "betterloadingscreen:textures/progressBars.png";
        String title = "textures/gui/title/mojang.png";
        String font = "textures/font/ascii.png";
        this.images[0] = new ImageRender(title, EPosition.CENTER, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 256, 256));
        this.images[1] = new ImageRender(font, EPosition.CENTER, EType.DYNAMIC_TEXT_STATUS, null, new Area(0, -30, 0, 0), "000000", null);
        this.images[2] = new ImageRender(font, EPosition.CENTER, EType.DYNAMIC_TEXT_PERCENTAGE, null, new Area(0, -40, 0, 0), "000000", null);
        this.images[3] = new ImageRender(progress, EPosition.CENTER, EType.STATIC, new Area(0, 10, 182, 5), new Area(0, -50, 182, 5));
        this.images[4] = new ImageRender(progress, EPosition.CENTER, EType.DYNAMIC_PERCENTAGE, new Area(0, 15, 182, 5), new Area(0, -50, 182, 5));
        ImageRender[] defaultImageRender = this.images;
        File imagesFile = new File(configDir, "images.json");
        JsonConfig<ImageRender[]> imagesConfig = new JsonConfig<ImageRender[]>(imagesFile, ImageRender[].class, this.images);
        this.images = imagesConfig.load();
        this.definePreset(configDir, "preset one", defaultImageRender);
        ImageRender[] presetData = new ImageRender[]{new ImageRender("textures/gui/options_background.png", EPosition.CENTER, EType.STATIC, new Area(0, 0, 65536, 65536), new Area(0, 0, 8192, 8192), "404040", null), new ImageRender(font, EPosition.CENTER, EType.DYNAMIC_TEXT_STATUS, null, new Area(0, 0, 0, 0), "FFFFFF", null), new ImageRender(font, EPosition.CENTER, EType.DYNAMIC_TEXT_PERCENTAGE, null, new Area(0, -10, 0, 0), "FFFFFF", null), new ImageRender(font, EPosition.BOTTOM_CENTER, EType.STATIC_TEXT, null, new Area(0, 10, 0, 0), "FFDD49", "Better Loading Screen by AlexIIL")};
        this.definePreset(configDir, "preset two", presetData);
    }

    private void definePreset(File configDir, String name, ImageRender ... images) {
        File presetFile = new File(configDir, name + ".json");
        JsonConfig<ImageRender[]> presetConfig = new JsonConfig<ImageRender[]>(presetFile, ImageRender[].class, images);
        presetConfig.createNew();
    }

    public void reDisplayProgress() {
        if (this.isOpen) {
            this.displayProgress(this.lastText, this.lastPercent);
        }
    }

    @Override
    public void displayProgress(String text, double percent) {
        this.lastText = text;
        this.lastPercent = percent;
        this.resolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        this.preDisplayScreen();
        for (ImageRender image : this.images) {
            if (image == null) continue;
            this.drawImageRender(image, text, percent);
        }
        this.postDisplayScreen();
        if (this.callAgain) {
            this.callAgain = false;
            this.reDisplayProgress();
        }
    }

    private FontRenderer fontRenderer(String fontTexture) {
        if (this.fontRenderers.containsKey(fontTexture)) {
            return this.fontRenderers.get(fontTexture);
        }
        FontRenderer font = new FontRenderer(this.mc.field_71474_y, new ResourceLocation(fontTexture), this.textureManager, false);
        font.func_110549_a(this.mc.func_110442_L());
        this.mc.func_110436_a();
        font.func_110549_a(this.mc.func_110442_L());
        this.fontRenderers.put(fontTexture, font);
        return font;
    }

    public void drawImageRender(ImageRender render, String text, double percent) {
        int startX = render.transformX(this.resolution.func_78326_a());
        int startY = render.transformY(this.resolution.func_78328_b());
        GlStateManager.func_179124_c((float)render.getRed(), (float)render.getGreen(), (float)render.getBlue());
        switch (render.type) {
            case DYNAMIC_PERCENTAGE: {
                ResourceLocation res = new ResourceLocation(render.resourceLocation);
                this.textureManager.func_110577_a(res);
                double alteredWidth = (double)render.position.width * percent;
                this.drawRect(startX, startY, alteredWidth, render.position.height, render.texture.x, render.texture.y, alteredWidth, render.texture.height);
                break;
            }
            case DYNAMIC_TEXT_PERCENTAGE: {
                FontRenderer font = this.fontRenderer(render.resourceLocation);
                String percentage = (int)(percent * 100.0) + "%";
                int width = font.func_78256_a(percentage);
                startX = render.positionType.transformX(render.position.x, this.resolution.func_78326_a() - width);
                startY = render.positionType.transformY(render.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                this.drawString(font, percentage, startX, startY, render.getColour());
                break;
            }
            case DYNAMIC_TEXT_STATUS: {
                FontRenderer font = this.fontRenderer(render.resourceLocation);
                int width = font.func_78256_a(text);
                startX = render.positionType.transformX(render.position.x, this.resolution.func_78326_a() - width);
                startY = render.positionType.transformY(render.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                this.drawString(font, text, startX, startY, render.getColour());
                break;
            }
            case STATIC_TEXT: {
                FontRenderer font = this.fontRenderer(render.resourceLocation);
                int width = font.func_78256_a(render.text);
                int startX1 = render.positionType.transformX(render.position.x, this.resolution.func_78326_a() - width);
                int startY1 = render.positionType.transformY(render.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                this.drawString(font, render.text, startX1, startY1, render.getColour());
                break;
            }
            default: {
                ResourceLocation res = new ResourceLocation(render.resourceLocation);
                this.textureManager.func_110577_a(res);
                this.drawRect(startX, startY, render.position.width, render.position.height, render.texture.x, render.texture.y, render.texture.width, render.texture.height);
                break;
            }
        }
    }

    public void drawString(FontRenderer font, String text, int x, int y, int colour) {
        font.func_78276_b(text, x, y, colour);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawRect(double x, double y, double drawnWidth, double drawnHeight, double u, double v, double uWidth, double vHeight) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer wr = tessellator.func_178180_c();
        wr.func_178970_b();
        wr.func_178985_a(x, y + drawnHeight, 0.0, u * (double)f, (v + vHeight) * (double)f);
        wr.func_178985_a(x + drawnWidth, y + drawnHeight, 0.0, (u + uWidth) * (double)f, (v + vHeight) * (double)f);
        wr.func_178985_a(x + drawnWidth, y, 0.0, (u + uWidth) * (double)f, v * (double)f);
        wr.func_178985_a(x, y, 0.0, u * (double)f, v * (double)f);
        tessellator.func_78381_a();
    }

    private void preDisplayScreen() {
        if (this.textureManager == null) {
            this.textureManager = this.mc.field_71446_o = new TextureManager(this.mc.func_110442_L());
            this.mc.func_110436_a();
            this.textureManager.func_110549_a(this.mc.func_110442_L());
            this.mc.field_71466_p = new FontRenderer(this.mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.textureManager, false);
            if (this.mc.field_71474_y.field_74363_ab != null) {
                LanguageManager lm = this.mc.func_135016_M();
                this.mc.field_71466_p.func_78264_a(this.mc.func_152349_b());
                this.mc.field_71466_p.func_78275_b(lm.func_135044_b());
            }
            this.mc.field_71466_p.func_110549_a(this.mc.func_110442_L());
            this.callAgain = true;
        }
        if (this.fontRenderer != this.mc.field_71466_p) {
            this.fontRenderer = this.mc.field_71466_p;
        }
        if (this.textureManager != this.mc.field_71446_o) {
            this.textureManager = this.mc.field_71446_o;
        }
        this.resolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)this.resolution.func_78326_a(), (double)this.resolution.func_78328_b(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        GlStateManager.func_179097_i();
        GlStateManager.func_179098_w();
        GlStateManager.func_179086_m((int)16640);
        GlStateManager.func_179082_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void postDisplayScreen() {
        this.mc.func_175601_h();
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.getOnlyList().remove(this.myPack);
    }

    static {
        defaultSound = "random.levelup";
    }
}

