/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import alexiil.mods.load.LoadingFrame;
import alexiil.mods.load.MinecraftDisplayerWrapper;
import alexiil.mods.load.Translation;
import java.awt.GraphicsEnvironment;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgressDisplayer {
    private static IDisplayer displayer;
    private static int clientState;
    public static Configuration cfg;
    public static boolean playSound;
    public static File coreModLocation;
    public static ModContainer modContainer;

    public static boolean isClient() {
        StackTraceElement[] steArr;
        if (clientState != -1) {
            return clientState == 1;
        }
        for (StackTraceElement ste : steArr = Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith("net.minecraftforge.fml.relauncher.ServerLaunchWrapper")) continue;
            clientState = 0;
            return false;
        }
        clientState = 1;
        return true;
    }

    public static void start(File coremodLocation) {
        coreModLocation = coremodLocation;
        if (coreModLocation == null) {
            coreModLocation = new File("./../bin/");
        }
        ModMetadata md = new ModMetadata();
        md.name = "Better Loading Screen";
        md.modId = "betterloadingscreen";
        modContainer = new DummyModContainer(md){

            public Class<?> getCustomResourcePackClass() {
                return FMLFileResourcePack.class;
            }

            public File getSource() {
                return coreModLocation;
            }

            public String getModId() {
                return "betterloadingscreen";
            }
        };
        File fileOld = new File("./config/betterloadingscreen.cfg");
        File fileNew = new File("./config/BetterLoadingScreen/config.cfg");
        Configuration cfg = fileOld.exists() ? new Configuration(fileOld) : new Configuration(fileNew);
        boolean useMinecraft = ProgressDisplayer.isClient();
        if (useMinecraft) {
            String comment = "Whether or not to use minecraft's display to show the progress. This looks better, but there is a possibilty of not being ";
            comment = comment + "compatible, so if you do have nay strange crash reports or compatability issues, try setting this to false";
            useMinecraft = cfg.getBoolean("useMinecraft", "general", true, comment);
        }
        playSound = cfg.getBoolean("playSound", "general", true, "Play a sound after minecraft has finished starting up");
        displayer = useMinecraft ? new MinecraftDisplayerWrapper() : (!GraphicsEnvironment.isHeadless() ? new FrameDisplayer() : new LoggingDisplayer());
        displayer.open(cfg);
        cfg.save();
    }

    public static void displayProgress(String text, double percent) {
        displayer.displayProgress(text, percent);
    }

    public static void close() {
        if (displayer == null) {
            return;
        }
        displayer.close();
        displayer = null;
        if (ProgressDisplayer.isClient() && playSound) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    MinecraftDisplayerWrapper.playFinishedSound();
                }
            }.start();
        }
    }

    public static void minecraftDisplayFirstProgress() {
        ProgressDisplayer.displayProgress(Translation.translate("betterloadingscreen.state.minecraft_init", "Minecraft Initializing"), 0.0);
    }

    static {
        clientState = -1;
    }

    public static class LoggingDisplayer
    implements IDisplayer {
        private Logger log;

        @Override
        public void open(Configuration cfg) {
            this.log = LogManager.getLogger((String)"betterloadingscreen");
        }

        @Override
        public void displayProgress(String text, double percent) {
            this.log.info(text + " (" + (int)(percent * 100.0) + "%)");
        }

        @Override
        public void close() {
        }
    }

    public static class FrameDisplayer
    implements IDisplayer {
        public LoadingFrame frame = null;

        @Override
        public void open(Configuration cfg) {
            this.frame = LoadingFrame.openWindow();
            if (this.frame != null) {
                this.frame.setMessage("Minecraft Forge Starting");
                this.frame.setProgress(0.0);
            }
        }

        @Override
        public void displayProgress(String text, double percent) {
            if (this.frame == null) {
                return;
            }
            this.frame.setMessage(text);
            this.frame.setProgress(percent * 100.0);
            this.frame.repaint();
        }

        @Override
        public void close() {
            if (this.frame != null) {
                this.frame.dispose();
            }
        }
    }

    public static interface IDisplayer {
        public void open(Configuration var1);

        public void displayProgress(String var1, double var2);

        public void close();
    }
}

