/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.coremod;

import alexiil.mods.load.ProgressDisplayer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class BetterLoadingScreenTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.Minecraft")) {
            return this.transformMinecraft(basicClass, transformedName.equals(name));
        }
        if (name.equals("com.mumfrey.liteloader.client.api.ObjectFactoryClient")) {
            return this.transformObjectFactoryClient(basicClass);
        }
        return basicClass;
    }

    private byte[] transformObjectFactoryClient(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("preBeginGame")) continue;
            m.instructions.clear();
            m.instructions.add((AbstractInsnNode)new TypeInsnNode(187, "alexiil/mods/load/LiteLoaderProgress"));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "alexiil/mods/load/LiteLoaderProgress", "<init>", "()V", false));
            m.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformMinecraft(byte[] before, boolean dev) {
        boolean hasFoundStartGame = false;
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        boolean found = false;
        String tryingToFind = dev ? "drawSplashScreen" : "func_180510_a";
        String minecraftStartGame = dev ? "startGame" : "func_71384_a";
        block0: for (MethodNode m : classNode.methods) {
            if (m.name.equals(tryingToFind)) {
                found = true;
                m.instructions.insertBefore(m.instructions.getFirst(), (AbstractInsnNode)new InsnNode(177));
                break;
            }
            if (!m.name.equals(minecraftStartGame)) continue;
            for (int i = 0; i < m.instructions.size(); ++i) {
                MethodInsnNode method;
                AbstractInsnNode node = m.instructions.get(i);
                if (node instanceof MethodInsnNode) {
                    method = (MethodInsnNode)node;
                    if (method.owner.equals("com/mumfrey/liteloader/client/gui/startup/LoadingBar")) {
                        m.instructions.remove((AbstractInsnNode)method);
                        continue;
                    }
                    if (method.owner.startsWith("com/mumfrey")) {
                        System.out.println("Started with \"com/mumfrey\", was actually \"" + method.owner + "\"");
                    }
                }
                if (!(node instanceof MethodInsnNode)) continue;
                method = (MethodInsnNode)node;
                if (!method.owner.equals(Type.getInternalName(FMLClientHandler.class)) || !method.name.equals("instance")) continue;
                MethodInsnNode newOne = new MethodInsnNode(184, Type.getInternalName(ProgressDisplayer.class), "minecraftDisplayFirstProgress", "()V", false);
                m.instructions.insertBefore((AbstractInsnNode)method, (AbstractInsnNode)newOne);
                hasFoundStartGame = true;
                continue block0;
            }
        }
        if (!found) {
            System.out.println("Did not find " + tryingToFind + "! Could it have been any of these?");
            for (MethodNode m : classNode.methods) {
                System.out.println("  -" + m.name);
            }
        }
        if (!hasFoundStartGame) {
            System.out.println("Did not find " + minecraftStartGame + "! Could it have been any of these?");
            for (MethodNode m : classNode.methods) {
                System.out.println("  -" + m.name);
            }
        }
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        System.out.println("Transformed Minecraft");
        return cw.toByteArray();
    }
}

