/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlexIILLibLog {
    private static Logger log;
    private static final ThreadLocal<Integer> stack;

    public static void trace(String message) {
        AlexIILLibLog.log(Level.TRACE, message);
    }

    public static void debug(String message) {
        AlexIILLibLog.log(Level.DEBUG, message);
    }

    public static void info(String toLog) {
        AlexIILLibLog.log(Level.INFO, toLog);
    }

    public static void warn(String text) {
        AlexIILLibLog.log(Level.WARN, text);
    }

    public static void warn(String message, Throwable thrown) {
        AlexIILLibLog.log(Level.WARN, message, thrown);
    }

    public static void log(Level level, String text) {
        AlexIILLibLog.log().log(level, text);
    }

    public static void log(Level level, String message, Throwable t) {
        AlexIILLibLog.log().log(level, message, t);
    }

    private static Logger log() {
        if (log == null) {
            log = LogManager.getLogger((String)"AlexIILLib");
        }
        return log;
    }

    @Deprecated
    public static void temp(String text) {
        AlexIILLibLog.info(text);
    }

    private static int getStack() {
        Integer i = stack.get();
        if (i == null) {
            return 0;
        }
        return i;
    }

    private static void logThing(String place, String arg, int indent) {
        StackTraceElement ste = Thread.currentThread().getStackTrace()[indent];
        String clazz = ste.getClassName().substring(ste.getClassName().lastIndexOf(46) + 1);
        String before = StringUtils.repeat((String)"  ", (int)AlexIILLibLog.getStack()) + place + " " + clazz + "." + ste.getMethodName();
        AlexIILLibLog.info(before + arg);
    }

    private static void logThing(String place, Object ... args) {
        String spaces = StringUtils.repeat((String)"  ", (int)(AlexIILLibLog.getStack() + 28));
        String arguments = "(";
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            String s = arg == null ? "null" : arg.toString();
            if ((s = s.replace("\n", "\n" + spaces + "  ")).length() > 30) {
                s = "\n" + spaces + "  " + s + "\n" + spaces;
            }
            if (arg instanceof String) {
                s = "\"" + s + "\"";
            }
            arguments = arguments + s;
            if (i >= args.length - 1) continue;
            arguments = arguments + ", ";
        }
        arguments = arguments + ")";
        AlexIILLibLog.logThing(place, arguments, 4);
    }

    private static String makeNewLine(String string) {
        if (string.length() < 30) {
            return string;
        }
        String spaces = StringUtils.repeat((String)"  ", (int)(AlexIILLibLog.getStack() + 28));
        if ((string = string.replace("\n", "\n" + spaces + "  ")).length() > 30) {
            string = "\n" + spaces + "  " + string + "\n" + spaces;
        }
        return string;
    }

    public static void justInvoke() {
        stack.set(AlexIILLibLog.getStack() + 1);
    }

    public static void justReturn() {
        stack.set(AlexIILLibLog.getStack() - 1);
    }

    public static void logInvoke(Object ... args) {
        AlexIILLibLog.logThing("invoke", args);
        AlexIILLibLog.justInvoke();
    }

    public static void logReturn() {
        AlexIILLibLog.justReturn();
        AlexIILLibLog.logThing("return", new Object[0]);
    }

    public static void logReturn(Object arg) {
        AlexIILLibLog.justReturn();
        AlexIILLibLog.logThing("return", arg);
    }

    public static void logIf(Object arg1, Object arg2, int opcode) {
        String text;
        boolean returnVal = false;
        switch (opcode) {
            case 165: 
            case 198: {
                text = arg1 + " == " + arg2;
                returnVal = arg1 == arg2;
                break;
            }
            case 166: 
            case 199: {
                text = arg1 + " != " + arg2;
                returnVal = arg1 != arg2;
                break;
            }
            case 153: 
            case 159: {
                text = arg1 + " == " + arg2;
                returnVal = arg1 != arg2;
                break;
            }
            case 154: 
            case 160: {
                text = arg1 + " != " + arg2;
                returnVal = arg1 != arg2;
                break;
            }
            case 158: 
            case 164: {
                text = arg1 + " <= " + arg2;
                returnVal = (Integer)arg1 <= (Integer)arg2;
                break;
            }
            case 155: 
            case 161: {
                text = arg1 + " < " + arg2;
                returnVal = (Integer)arg1 < (Integer)arg2;
                break;
            }
            case 156: 
            case 162: {
                text = arg1 + " >= " + arg2;
                returnVal = (Integer)arg1 >= (Integer)arg2;
                break;
            }
            case 157: 
            case 163: {
                text = arg1 + " > " + arg2;
                returnVal = (Integer)arg1 > (Integer)arg2;
                break;
            }
            default: {
                text = "Unknown Opcode " + opcode;
            }
        }
        AlexIILLibLog.logThing("if", "(" + AlexIILLibLog.makeNewLine(text) + ") returned " + returnVal, 3);
    }

    static {
        stack = new ThreadLocal();
    }
}

