/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib;

import alexiil.mods.lib.BlockPosUtils;
import java.util.ArrayDeque;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

public class SearchBox
implements Iterable<BlockPos> {
    public BlockPos min;
    public BlockPos max;
    public BlockPos cur;
    public boolean posX;
    public boolean posY;
    public boolean posZ;
    public ArrayDeque<BlockPos> toSearch;
    public boolean doOnce = true;
    public boolean isDone = false;
    private boolean forceOnce = false;
    public long progress = 0L;
    public long size;

    public SearchBox(SearchBox box) {
        this.max = box.max;
        this.min = box.min;
        this.cur = box.cur;
        this.resetCurrent();
        this.calcSize();
    }

    public SearchBox(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public SearchBox(BlockPos min, BlockPos max) {
        this.min = min;
        this.max = max;
        this.cur = min;
    }

    public SearchBox(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        this.min = new BlockPos(minX, minY, minZ);
        this.max = new BlockPos(maxX, maxY, maxZ);
        this.resetCurrent();
        this.calcSize();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        BlockPosUtils.saveToNBT(this.min, "min");
        BlockPosUtils.saveToNBT(this.max, "max");
        BlockPosUtils.saveToNBT(this.cur, "cur");
        nbt.func_74757_a("DirectionX", this.posX);
        nbt.func_74757_a("DirectionY", this.posY);
        nbt.func_74757_a("DirectionZ", this.posZ);
        nbt.func_74768_a("ToSearch", this.toSearch.size());
        nbt.func_74772_a("Progress", this.progress);
        for (int a = this.toSearch.size() - 1; a >= 0; --a) {
            BlockPosUtils.saveToNBT(this.toSearch.pop(), Integer.toString(a));
        }
        nbt.func_74757_a("doOnce", this.doOnce);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.min = BlockPosUtils.readFromNBT(nbt, "min");
        this.max = BlockPosUtils.readFromNBT(nbt, "min");
        this.cur = BlockPosUtils.readFromNBT(nbt, "min");
        this.posX = nbt.func_74767_n("DirectionX");
        this.posY = nbt.func_74767_n("DirectionY");
        this.posZ = nbt.func_74767_n("DirectionZ");
        this.progress = nbt.func_74763_f("Progress");
        int cors = nbt.func_74762_e("ToSearch");
        this.toSearch = new ArrayDeque(cors);
        for (int a = 0; a < cors; ++a) {
            this.toSearch.push(BlockPosUtils.readFromNBT(nbt, Integer.toString(a)));
        }
        this.calcSize();
        this.doOnce = nbt.func_74767_n("doOnce");
    }

    public void calcSize() {
        this.size = (this.max.func_177958_n() - this.min.func_177958_n() + 1) * (this.max.func_177956_o() - this.min.func_177956_o() + 1) * (this.max.func_177952_p() - this.min.func_177952_p() + 1);
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void expand(int amount) {
        this.min = this.min.func_177972_a(EnumFacing.DOWN).func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.WEST);
        this.max = this.max.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.EAST);
        this.calcSize();
    }

    public void resetCurrent() {
        this.cur = new BlockPos(this.min.func_177958_n(), this.max.func_177956_o(), this.min.func_177952_p());
        this.posX = true;
        this.posY = false;
        this.posZ = true;
        this.toSearch = new ArrayDeque();
    }

    public void contract(int amount) {
        this.expand(-amount);
    }

    private void calcNext() {
        ++this.progress;
        if (this.cur.func_177958_n() == this.max.func_177958_n() && this.posX) {
            this.posX = false;
        } else if (this.cur.func_177958_n() == this.min.func_177958_n() && !this.posX) {
            this.posX = true;
        } else {
            this.cur = this.cur.func_177972_a(this.posX ? EnumFacing.EAST : EnumFacing.WEST);
            return;
        }
        if (this.cur.func_177952_p() == this.max.func_177952_p() && this.posZ) {
            this.posZ = false;
        } else if (this.cur.func_177952_p() == this.min.func_177952_p() && !this.posZ) {
            this.posZ = true;
        } else {
            this.cur = this.cur.func_177972_a(this.posZ ? EnumFacing.SOUTH : EnumFacing.NORTH);
            return;
        }
        if ((this.doOnce || this.forceOnce) && this.cur.func_177956_o() == this.min.func_177956_o()) {
            this.isDone = true;
            return;
        }
        if (this.cur.func_177956_o() == this.max.func_177956_o() && this.posY) {
            this.posY = false;
        } else if (this.cur.func_177956_o() == this.min.func_177956_o() && !this.posY) {
            this.posY = true;
        } else {
            this.cur = this.cur.func_177972_a(this.posY ? EnumFacing.UP : EnumFacing.DOWN);
        }
    }

    public boolean isOnEdge(BlockPos pos) {
        return this.getMatches(pos) > 0;
    }

    public boolean isInside(BlockPos pos) {
        return pos.func_177958_n() >= this.min.func_177958_n() && pos.func_177958_n() <= this.max.func_177958_n() && pos.func_177956_o() >= this.min.func_177956_o() && pos.func_177956_o() <= this.max.func_177956_o() && pos.func_177952_p() >= this.min.func_177952_p() && pos.func_177952_p() <= this.max.func_177952_p();
    }

    public boolean isOnVertex(BlockPos pos) {
        return this.getMatches(pos) > 1;
    }

    public int getMatches(BlockPos pos) {
        int matches = 0;
        if (pos.func_177958_n() == this.min.func_177958_n() || pos.func_177958_n() == this.max.func_177958_n()) {
            ++matches;
        }
        if (pos.func_177956_o() == this.min.func_177956_o() || pos.func_177956_o() == this.max.func_177956_o()) {
            ++matches;
        }
        if (pos.func_177952_p() == this.min.func_177952_p() || pos.func_177952_p() == this.max.func_177952_p()) {
            ++matches;
        }
        return matches;
    }

    public BlockPos current() {
        if (this.toSearch.isEmpty()) {
            return this.cur;
        }
        return this.toSearch.peek();
    }

    public BlockPos next() {
        if (this.toSearch.isEmpty()) {
            this.calcNext();
            return this.current();
        }
        return this.toSearch.pop();
    }

    public String toString() {
        return this.progress + "/" + this.size;
    }

    public void pushNext(BlockPos pos) {
        this.toSearch.push(pos);
    }

    public SearchBoxIterator iterator() {
        SearchBox box = new SearchBox(this);
        box.forceOnce = true;
        return box.new SearchBoxIterator();
    }

    public class SearchBoxIterator
    implements Iterator<BlockPos> {
        @Override
        public boolean hasNext() {
            return !SearchBox.this.isDone();
        }

        @Override
        public BlockPos next() {
            return SearchBox.this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public void add(BlockPos pos) {
            SearchBox.this.pushNext(pos);
        }

        public BlockPos peek() {
            return SearchBox.this.current();
        }
    }
}

