/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib;

import alexiil.mods.lib.BlockPosUtils;
import alexiil.mods.lib.SearchBox;
import alexiil.version.api.VersionedApi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.chunk.Chunk;

public class SearchUtils {
    @VersionedApi.Final
    public static SearchBox searchChunk(Chunk chunk) {
        BlockPos min = new BlockPos(chunk.field_76635_g << 4, 0, chunk.field_76647_h << 4);
        BlockPos max = min.func_177982_a(15, 255, 15);
        return new SearchBox(min, max);
    }

    @VersionedApi.Final
    public static Iterable<BlockPos> searchFaces(BlockPos pos) {
        ArrayList positions = Lists.newArrayList();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            positions.add(BlockPosUtils.move(pos, dir));
        }
        return positions;
    }

    @VersionedApi.Final
    public static Iterable<BlockPos> searchAround(BlockPos pos, int radius) {
        BlockPos min = pos.func_177982_a(-radius, -radius, -radius);
        BlockPos max = pos.func_177982_a(radius, radius, radius);
        SearchBox sb = new SearchBox(min, max);
        return new ExcludingIterable(sb, pos);
    }

    private static class ExcludingIterable
    implements Iterable<BlockPos> {
        private final SearchBox box;
        private final BlockPos excluded;

        public ExcludingIterable(SearchBox box, BlockPos positions) {
            this.box = box;
            this.excluded = positions;
        }

        @Override
        public Iterator<BlockPos> iterator() {
            return new ExcludingIterator();
        }

        private class ExcludingIterator
        implements Iterator<BlockPos> {
            private final SearchBox.SearchBoxIterator sbi;

            private ExcludingIterator() {
                this.sbi = ExcludingIterable.this.box.iterator();
            }

            @Override
            public boolean hasNext() {
                if (!this.sbi.hasNext()) {
                    return false;
                }
                BlockPos next = this.sbi.peek();
                if (next.equals((Object)ExcludingIterable.this.excluded)) {
                    this.next();
                }
                return this.sbi.hasNext();
            }

            @Override
            public BlockPos next() {
                BlockPos pos = this.sbi.next();
                if (pos.equals((Object)ExcludingIterable.this.excluded)) {
                    return this.sbi.next();
                }
                return pos;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

