/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.gui;

import alexiil.mods.lib.AlexIILMod;
import alexiil.mods.lib.LangUtils;
import alexiil.mods.lib.git.GitHubUser;
import alexiil.mods.lib.gui.ActualConfig;
import alexiil.mods.lib.gui.CommitScrollingList;
import alexiil.mods.lib.gui.GitHubUserScrollingList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public abstract class BaseConfig
extends GuiScreen {
    private GitHubUserScrollingList contributors;
    private CommitScrollingList commits;
    public final AlexIILMod mod;
    private GuiButton helpClose;
    private boolean help = false;
    private int xPosHelp = 0;
    private List<List<String>> helpText;
    protected int totalLength;

    public BaseConfig(GuiScreen screen, AlexIILMod mod) {
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.mod = mod;
        this.setupGui();
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.setupGui();
    }

    protected void setupGui() {
        String text;
        String preTranslation;
        int width = 0;
        for (GitHubUser usr : this.mod.getContributors()) {
            width = Math.max(width, this.field_146289_q.func_78256_a(usr.login));
        }
        this.contributors = new GitHubUserScrollingList(this, width + 40, this.field_146295_m, 40, this.field_146295_m - 40, 10);
        for (GitHubUser c : this.mod.getContributors()) {
            this.contributors.userList.add(c);
        }
        this.commits = new CommitScrollingList(this, this.field_146294_l - width - 80, this.field_146295_m, 40, this.field_146295_m - 40, width + 60);
        int index = 0;
        int maxXPos = Math.min(this.field_146294_l - this.xPosHelp, 400);
        this.helpText = new ArrayList<List<String>>();
        while (!(preTranslation = "alexiillib.gui.config.help." + index).equals(text = LangUtils.format(preTranslation, new Object[0]))) {
            String[] strings1 = text.split("\n");
            for (int i = 0; i < strings1.length; ++i) {
                String s;
                String nextLine = "";
                for (s = strings1[i]; this.field_146289_q.func_78256_a(s) > maxXPos && s != null && s.length() > 10; s = s.substring(0, s.length() - 1)) {
                    nextLine = s.substring(s.length() - 1) + nextLine;
                }
                if (nextLine.length() <= 0) continue;
                strings1 = Arrays.copyOf(strings1, strings1.length + 1);
                strings1[i] = s;
                strings1[i + 1] = nextLine;
            }
            String[] strings = strings1;
            this.helpText.add(Arrays.asList(strings));
            ++index;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String text;
        this.func_146278_c(0);
        if (this.mod.connectExternally.getBoolean()) {
            this.commits.drawScreen(mouseX, mouseY, partialTicks);
            this.contributors.drawScreen(mouseX, mouseY, partialTicks);
            this.func_73731_b(this.field_146289_q, LangUtils.format("alexiillib.gui.contributors", new Object[0]), 8, 30, 0xFFFFFF);
            text = LangUtils.format("alexiillib.gui.commits", new Object[0]);
            this.func_73731_b(this.field_146289_q, text, this.field_146294_l - this.field_146289_q.func_78256_a(text) - 10, 30, 0xFFFFFF);
        } else {
            text = LangUtils.format("alexiillib.gui.connectExternallyDisabled", new Object[0]);
            int textWidth = this.field_146289_q.func_78256_a(text);
            this.func_146283_a(Collections.singletonList(text), (this.field_146294_l - textWidth) / 2, this.field_146295_m / 2);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.help) {
            int yHeight = 0;
            for (List<String> ss : this.helpText) {
                yHeight += this.field_146289_q.field_78288_b * (ss.size() + 1);
            }
            this.func_73733_a(this.xPosHelp, 40, this.xPosHelp + 440, yHeight + 80, -16777216, -16777216);
            int yPos = 60;
            for (List<String> strings : this.helpText) {
                this.func_146283_a(strings, this.xPosHelp, yPos);
                yPos += (strings.size() + 2) * this.field_146289_q.field_78288_b;
            }
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void func_73866_w_() {
        String text = LangUtils.format("alexiillib.config.button", new Object[0]);
        int length = this.field_146289_q.func_78256_a(text) + 20;
        this.totalLength = 10;
        this.field_146292_n.add(new GuiButton(0, this.totalLength, 1, length, 20, text));
        this.totalLength += length;
        text = LangUtils.format("alexiillib.config.help", new Object[0]);
        length = this.field_146289_q.func_78256_a(text) + 20;
        this.field_146292_n.add(new GuiButton(1, this.totalLength, 1, length, 20, text));
        this.xPosHelp = this.totalLength;
        this.totalLength += length;
        text = LangUtils.format("alexiillib.config.closeHelp", new Object[0]);
        length = this.field_146289_q.func_78256_a(text) + 20;
        this.helpClose = new GuiButton(2, this.totalLength, 1, length, 20, text);
        this.helpClose.field_146125_m = false;
        this.field_146292_n.add(this.helpClose);
        this.totalLength += length;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new ActualConfig(this, this.mod));
        }
        if (button.field_146127_k == 1) {
            this.help = true;
            this.helpClose.field_146125_m = true;
        }
        if (button.field_146127_k == 2 && this.helpClose.field_146125_m) {
            this.help = false;
            this.helpClose.field_146125_m = false;
        }
    }
}

