/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.item;

import alexiil.mods.lib.block.BlockMeta;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public final class ItemMeta {
    public final Item item;
    public final int meta;
    public static final String NBT_META = "ITEM.META";
    public static final String NBT_ITEM = "ITEM.ITEM";
    private static ArrayList<ItemMeta> itemMetaPool = new ArrayList();

    private ItemMeta(Item item, int meta) {
        this.item = item;
        this.meta = meta;
        itemMetaPool.add(this);
    }

    public static ItemMeta get(Item block, int meta) {
        if (block == null) {
            return null;
        }
        for (ItemMeta bm : itemMetaPool) {
            if (!bm.item.equals(block) || bm.meta != meta) continue;
            return bm;
        }
        return new ItemMeta(block, meta);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + this.meta;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockMeta other = (BlockMeta)obj;
        if (this.item == null ? other.block != null : !this.item.equals(other.block)) {
            return false;
        }
        return this.meta == other.meta;
    }

    public String toString() {
        String toShow;
        try {
            toShow = I18n.func_135052_a((String)this.item.func_77658_a(), (Object[])new Object[0]) + ":" + this.meta;
        }
        catch (Throwable t) {
            toShow = this.item + ":" + this.meta;
        }
        return toShow;
    }

    public static ItemMeta readFromNBT(NBTTagCompound nbt) {
        return ItemMeta.get((Item)Item.field_150901_e.func_82594_a((Object)nbt.func_74779_i(NBT_ITEM)), nbt.func_74762_e(NBT_META));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_META, this.meta);
        nbt.func_74778_a(NBT_ITEM, (String)Block.field_149771_c.func_177774_c((Object)this.item));
    }
}

