/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.tile;

import alexiil.mods.lib.AlexIILMod;
import alexiil.mods.lib.net.INetworkTile;
import alexiil.mods.lib.net.MessageUpdate;
import alexiil.mods.lib.tile.TileEntityBasic;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileEntityUpdated<M extends MessageUpdate<?, ?>>
extends TileEntityBasic
implements INetworkTile<M> {
    private int updated;
    public final AlexIILMod mod;
    private NetworkRegistry.TargetPoint point = null;

    public TileEntityUpdated(AlexIILMod mod) {
        this.mod = mod;
    }

    @Override
    public void onTick() {
        ++this.updated;
        if (this.updated >= this.mod.netRate.getInt()) {
            this.updated = 0;
            if (this.needsNetworkUpdate()) {
                this.sendUpdatePacket();
            }
        }
    }

    protected void resetTargetPoint() {
        this.point = null;
    }

    private NetworkRegistry.TargetPoint targetPoint() {
        if (this.point == null) {
            this.point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.func_177502_q(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.mod.netDistance.getInt());
        }
        return this.point;
    }

    public void sendUpdatePacket() {
        this.mod.provider.get().sendToAllAround((IMessage)this.getCustomUpdateMessage(), this.targetPoint());
    }

    public boolean needsNetworkUpdate() {
        return true;
    }
}

