/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.sk89q.bukkit.migration.PermissionsProvider;
import com.sk89q.bukkit.migration.PermissionsResolver;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.util.config.Configuration;

public class PluginPermissionsResolver
implements PermissionsResolver {
    protected PermissionsProvider resolver;
    protected Plugin plugin;

    public static PermissionsResolver factory(Server server, Configuration config) {
        RegisteredServiceProvider serviceProvider = server.getServicesManager().getRegistration(PermissionsProvider.class);
        if (serviceProvider != null) {
            return new PluginPermissionsResolver((PermissionsProvider)serviceProvider.getProvider(), serviceProvider.getPlugin());
        }
        for (Plugin plugin : server.getPluginManager().getPlugins()) {
            if (!(plugin instanceof PermissionsProvider)) continue;
            return new PluginPermissionsResolver((PermissionsProvider)plugin, plugin);
        }
        return null;
    }

    public PluginPermissionsResolver(PermissionsProvider resolver, Plugin permissionsPlugin) {
        this.resolver = resolver;
        this.plugin = permissionsPlugin;
    }

    public void load() {
    }

    public boolean hasPermission(String name, String permission) {
        return this.resolver.hasPermission(name, permission);
    }

    public boolean hasPermission(String worldName, String name, String permission) {
        return this.resolver.hasPermission(worldName, name, permission);
    }

    public boolean inGroup(String player, String group) {
        return this.resolver.inGroup(player, group);
    }

    public String[] getGroups(String player) {
        return this.resolver.getGroups(player);
    }

    public String getDetectionMessage() {
        return "Using plugin '" + this.plugin.getDescription().getName() + "' for permissions.";
    }
}

