/*
 * Decompiled with CFR 0.152.
 */
package rimevel.SimplySit.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rimevel.SimplySit.entities.EntitySitPoint;
import rimevel.SimplySit.network.ServerMessageHandler;
import rimevel.SimplySit.util.VectorUtilites;

public class PacketKeySit
implements IMessage {
    int key;

    public PacketKeySit() {
    }

    public PacketKeySit(int key) {
        this.key = key;
    }

    public void fromBytes(ByteBuf buffer) {
        this.key = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)1);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.key, (int)1);
    }

    public static class PacketKeySitHandler
    extends ServerMessageHandler {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, IMessage message, MessageContext ctx) {
            int z;
            int y;
            int x;
            World world;
            MovingObjectPosition pos;
            PacketKeySit m = (PacketKeySit)message;
            if (m.key == 0 && (pos = VectorUtilites.getPointPlayerIsLookingAt(world = player.field_70170_p, player, 4.0)) != null && this.canSit(world, x = pos.field_72311_b, y = pos.field_72312_c, z = pos.field_72309_d, player)) {
                double height = this.getSittingHeight(world, x, y, z);
                EntitySitPoint point = new EntitySitPoint(world, x, y, z, height);
                world.func_72838_d((Entity)point);
                player.func_70078_a((Entity)point);
                point.field_70153_n = player;
            }
            return null;
        }

        private boolean canSit(World world, int x, int y, int z, EntityPlayer player) {
            Block block = world.func_147439_a(x, y, z);
            double radius = 0.5;
            if (!this.canPlayerReachSpot(player, x, y, z)) {
                return false;
            }
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)x - radius), (double)((double)y - radius), (double)((double)z - radius), (double)((double)x + radius), (double)((double)y + radius), (double)((double)z + radius));
            List list = world.func_72872_a(EntitySitPoint.class, box);
            if (!list.isEmpty()) {
                return false;
            }
            if (player.field_70154_o == null && !block.isFoliage((IBlockAccess)world, x, y, z)) {
                if (block.func_149669_A() == 1.0) {
                    if ((world.func_147437_c(x, y + 1, z) || world.func_147439_a(x, y + 1, z).func_149688_o() == Material.field_151586_h) && world.func_147437_c(x, y + 2, z)) {
                        return true;
                    }
                } else {
                    Block topBlock = world.func_147439_a(x, y + 2, z);
                    double sittingLevel = block.func_149669_A();
                    if (sittingLevel >= 0.5 && world.func_147437_c(x, y + 2, z)) {
                        return true;
                    }
                    if (sittingLevel <= 0.5 && topBlock.func_149669_A() <= 0.5) {
                        return true;
                    }
                }
            }
            return false;
        }

        private double getSittingHeight(World world, int x, int y, int z) {
            Block block = world.func_147439_a(x, y, z);
            if (block != null) {
                return block.func_149669_A();
            }
            return 0.0;
        }

        private boolean canPlayerReachSpot(EntityPlayer player, int targetX, int targetY, int targetZ) {
            int y = MathHelper.func_76128_c((double)(player.field_70163_u - 0.02 - (double)player.field_70129_M));
            return targetY - y <= 1 && y - targetY >= -1;
        }
    }
}

