/*
 * Decompiled with CFR 0.152.
 */
package rimevel.SimplySit.util;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class VectorUtilites {
    public static MovingObjectPosition getPointPlayerIsLookingAt(World world, EntityPlayer player, double distance) {
        Vec3 lookingPos = player.func_70040_Z();
        Vec3 playerPos = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 targetPos = Vec3.func_72443_a((double)(player.field_70165_t + lookingPos.field_72450_a * distance), (double)(player.field_70163_u + (double)player.func_70047_e() + lookingPos.field_72448_b * distance), (double)(player.field_70161_v + lookingPos.field_72449_c * distance));
        MovingObjectPosition pos = VectorUtilites.clip(world, playerPos, targetPos);
        return pos;
    }

    public static Block getBlockPlayerIsLookingAt(World world, EntityPlayer player, double distance) {
        MovingObjectPosition pos = VectorUtilites.getPointPlayerIsLookingAt(world, player, distance);
        if (pos != null) {
            return world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        }
        return null;
    }

    public static MovingObjectPosition clip(World world, Vec3 vec_one, Vec3 vec_two) {
        return VectorUtilites.rayTraceBlocks(world, vec_one, vec_two, false, false);
    }

    public static MovingObjectPosition clip(World world, Vec3 vec_one, Vec3 vec_two, boolean par3) {
        return VectorUtilites.rayTraceBlocks(world, vec_one, vec_two, par3, false);
    }

    public static MovingObjectPosition rayTraceBlocks(World world, Vec3 vec_one, Vec3 vec_two, boolean par3, boolean par4) {
        if (!(Double.isNaN(vec_one.field_72450_a) || Double.isNaN(vec_one.field_72448_b) || Double.isNaN(vec_one.field_72449_c))) {
            if (!(Double.isNaN(vec_two.field_72450_a) || Double.isNaN(vec_two.field_72448_b) || Double.isNaN(vec_two.field_72449_c))) {
                MovingObjectPosition movingobjectposition;
                int x2 = MathHelper.func_76128_c((double)vec_two.field_72450_a);
                int y2 = MathHelper.func_76128_c((double)vec_two.field_72448_b);
                int z2 = MathHelper.func_76128_c((double)vec_two.field_72449_c);
                int x = MathHelper.func_76128_c((double)vec_one.field_72450_a);
                int y = MathHelper.func_76128_c((double)vec_one.field_72448_b);
                int z = MathHelper.func_76128_c((double)vec_one.field_72449_c);
                int meta = world.func_72805_g(x, y, z);
                Block block = world.func_147439_a(x, y, z);
                if (block != null && (!par4 || block == null || block.func_149668_a(world, x, y, z) != null) && block != null && block != Blocks.field_150350_a && block.func_149678_a(meta, par3) && (movingobjectposition = block.func_149731_a(world, x, y, z, vec_one, vec_two)) != null) {
                    return movingobjectposition;
                }
                int i = 200;
                while (i-- >= 0) {
                    MovingObjectPosition movingobjectposition1;
                    int b0;
                    if (Double.isNaN(vec_one.field_72450_a) || Double.isNaN(vec_one.field_72448_b) || Double.isNaN(vec_one.field_72449_c)) {
                        return null;
                    }
                    if (x == x2 && y == y2 && z == z2) {
                        return null;
                    }
                    boolean flag2 = true;
                    boolean flag3 = true;
                    boolean flag4 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (x2 > x) {
                        d0 = (double)x + 1.0;
                    } else if (x2 < x) {
                        d0 = (double)x + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (y2 > y) {
                        d1 = (double)y + 1.0;
                    } else if (y2 < y) {
                        d1 = (double)y + 0.0;
                    } else {
                        flag3 = false;
                    }
                    if (z2 > z) {
                        d2 = (double)z + 1.0;
                    } else if (z2 < z) {
                        d2 = (double)z + 0.0;
                    } else {
                        flag4 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec_two.field_72450_a - vec_one.field_72450_a;
                    double d7 = vec_two.field_72448_b - vec_one.field_72448_b;
                    double d8 = vec_two.field_72449_c - vec_one.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec_one.field_72450_a) / d6;
                    }
                    if (flag3) {
                        d4 = (d1 - vec_one.field_72448_b) / d7;
                    }
                    if (flag4) {
                        d5 = (d2 - vec_one.field_72449_c) / d8;
                    }
                    boolean flag5 = false;
                    if (d3 < d4 && d3 < d5) {
                        b0 = i > x ? 4 : 5;
                        vec_one.field_72450_a = d0;
                        vec_one.field_72448_b += d7 * d3;
                        vec_one.field_72449_c += d8 * d3;
                    } else if (d4 < d5) {
                        b0 = y2 > y ? 0 : 1;
                        vec_one.field_72450_a += d6 * d4;
                        vec_one.field_72448_b = d1;
                        vec_one.field_72449_c += d8 * d4;
                    } else {
                        b0 = z2 > z ? 2 : 3;
                        vec_one.field_72450_a += d6 * d5;
                        vec_one.field_72448_b += d7 * d5;
                        vec_one.field_72449_c = d2;
                    }
                    Vec3 vec32 = Vec3.func_72443_a((double)vec_one.field_72450_a, (double)vec_one.field_72448_b, (double)vec_one.field_72449_c);
                    vec32.field_72450_a = MathHelper.func_76128_c((double)vec_one.field_72450_a);
                    x = (int)vec32.field_72450_a;
                    if (b0 == 5) {
                        --x;
                        vec32.field_72450_a += 1.0;
                    }
                    vec32.field_72448_b = MathHelper.func_76128_c((double)vec_one.field_72448_b);
                    y = (int)vec32.field_72448_b;
                    if (b0 == 1) {
                        --y;
                        vec32.field_72448_b += 1.0;
                    }
                    vec32.field_72449_c = MathHelper.func_76128_c((double)vec_one.field_72449_c);
                    z = (int)vec32.field_72449_c;
                    if (b0 == 3) {
                        --z;
                        vec32.field_72449_c += 1.0;
                    }
                    int meta2 = world.func_72805_g(x, y, z);
                    Block block2 = world.func_147439_a(x, y, z);
                    if (par4 && block2 != null && block2.func_149668_a(world, x, y, z) == null || block2 == Blocks.field_150350_a || !block2.func_149678_a(meta2, par3) || (movingobjectposition1 = block2.func_149731_a(world, x, y, z, vec_one, vec_two)) == null) continue;
                    return movingobjectposition1;
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

