/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.classes;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Properties;
import swedtech.mcskinedit.classes.Location;

public class Settings
extends Properties {
    private static Settings instance = null;
    private static final String[] locations = new String[]{Location.skinEdit() + "settings.xml", Location.settings() + "settings.xml", "settings.xml", System.getProperty("user.dir") + File.separator + ".skinedit" + File.separator + "settings.xml"};

    public static Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
            boolean success = false;
            for (String l : locations) {
                try {
                    System.out.println("Trying to load " + l);
                    BufferedInputStream i = new BufferedInputStream(new FileInputStream(l));
                    instance.loadFromXML(i);
                    System.out.println("Success!");
                    success = true;
                    break;
                }
                catch (IOException ex) {
                    System.out.println("Failed!");
                }
            }
            if (!success) {
                System.out.println("No settings file found!");
            }
        }
        return instance;
    }

    public Object setProperty(String key, String def) {
        super.setProperty(key, def);
        System.out.println("Saving settings...");
        new Thread(new Runnable(){

            public void run() {
                boolean success = false;
                for (String l : locations) {
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(l));
                        Settings.this.storeToXML(out, "\nSkinEdit settings\nAutomaticly generated at " + Calendar.getInstance().getTime().toString() + "\n\nBe careful when editing this file - don't edit unless you know what you are doing!\n");
                        success = true;
                        break;
                    }
                    catch (IOException ex) {
                        System.out.println("Failed to save as " + l);
                    }
                }
                System.out.println(success ? "Settings saved!" : "Couldn't save settings!");
            }
        }).start();
        return null;
    }

    public boolean getBoolean(String key, boolean def) {
        String in = this.getProperty(key);
        if (in == null) {
            return def;
        }
        if (in.equalsIgnoreCase("true")) {
            return true;
        }
        if (in.equalsIgnoreCase("false")) {
            return false;
        }
        return def;
    }

    public int getInteger(String key, int def) {
        String in = this.getProperty(key);
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }

    public float getFloat(String key, float def) {
        String in = this.getProperty(key, Float.toString(def));
        try {
            return Float.parseFloat(in);
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }

    public Color getColor(String key, Color def) {
        String in = this.getProperty(key);
        try {
            return new Color(Integer.parseInt(in));
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }
}

