/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.frames;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import swedtech.mcskinedit.Launcher;

public class ErrorScreen
extends JFrame
implements ActionListener {
    public static ErrorScreen instance;
    private static final String newline = "\n------------------------------\n\n";
    private JTextArea errors;

    public static void addError(String error) {
        if (instance == null) {
            instance = new ErrorScreen();
            instance.append("SkinEdit: SkinEdit - alpha 3 pre 7\n");
            instance.append("Java version: " + System.getProperty("java.version") + " (by " + System.getProperty("java.vendor") + " (detected as java" + Launcher.JAVAVERSION + ")\n");
            instance.append("Operating system: " + System.getProperty("os.name") + " version " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        }
        instance.append(newline);
        System.err.println("ErrorScreen displaying error:\n" + error);
        instance.append(error);
        instance.setVisible(true);
        instance.requestFocus();
        instance.setAlwaysOnTop(true);
    }

    public static void addError(Throwable ex) {
        ErrorScreen.addError(ex, null);
    }

    public static void addError(Throwable ex, String msg) {
        msg = msg == null ? "" : msg + "\n";
        msg = msg + ErrorScreen.exStr(ex);
        ErrorScreen.addError(msg);
    }

    private static String exStr(Throwable ex) {
        String ret = ex + "\n";
        for (StackTraceElement s : ex.getStackTrace()) {
            ret = ret + "        at " + s.getClassName() + "." + s.getMethodName() + "(" + s.getFileName() + ":" + s.getLineNumber() + ")\n";
        }
        return ret;
    }

    private ErrorScreen() {
        super("SkinEdit errors");
        this.setDefaultCloseOperation(1);
        JPanel pane = new JPanel(new BorderLayout());
        this.add(pane);
        JLabel text = new JLabel("SkinEdit encountered a problem! If you can't find a solution in the forum please report this!", 0);
        pane.add((Component)text, "North");
        this.errors = new JTextArea(20, 40);
        this.errors.setEditable(false);
        this.errors.setForeground(new Color(128, 0, 0));
        pane.add((Component)new JScrollPane(this.errors), "Center");
        JButton button = new JButton("Copy and go to forum topic");
        button.addActionListener(this);
        pane.add((Component)button, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void append(String error) {
        this.errors.append(error);
    }

    private void displayForum() {
        try {
            StringSelection stringSelection = new StringSelection(this.errors.getText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Couldn't copy to clipboard, please do this manually!");
        }
        if (Launcher.JAVAVERSION >= 6 && Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    URI uri = new URI("http://www.minecraftforum.net/viewtopic.php?f=27&t=4843&start=1200#p2327609");
                    desktop.browse(uri);
                }
                catch (Exception ex) {
                    JOptionPane.showInputDialog(this, "Couldn't open your browser, please use this link to go to the forum", "http://www.minecraftforum.net/viewtopic.php?f=27&t=4843&start=1200#p2327609");
                }
            } else {
                JOptionPane.showInputDialog(this, "Couldn't open your browser, please use this link to go to the forum", "http://www.minecraftforum.net/viewtopic.php?f=27&t=4843&start=1200#p2327609");
            }
        } else {
            JOptionPane.showInputDialog(this, "Please copy the following URL to your webbrowser:", "http://www.minecraftforum.net/viewtopic.php?f=27&t=4843&start=1200#p2327609");
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.displayForum();
    }
}

