/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.frames;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.classes.ImageHandle;
import swedtech.mcskinedit.classes.Location;
import swedtech.mcskinedit.classes.RadioButtonWithValue;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.classes.ToolToolbar;
import swedtech.mcskinedit.classes.VMenuItem;
import swedtech.mcskinedit.frames.AboutBox;
import swedtech.mcskinedit.frames.ControllsBox;
import swedtech.mcskinedit.frames.ErrorScreen;
import swedtech.mcskinedit.frames.SliderOptionPane;
import swedtech.mcskinedit.frames.partpicker.PartsPicker;
import swedtech.mcskinedit.icons.ProgramIcon;
import swedtech.mcskinedit.panels.EditArea;
import swedtech.mcskinedit.panels.PreviewPane;
import swedtech.mcskinedit.panels.ProgramPane;
import swedtech.mcskinedit.panels.TempColorChooser;

public class ProgramWindow
implements ActionListener,
WindowListener {
    public static ProgramWindow instance;
    public final JFrame frame;
    public final EditArea editarea;
    public final TempColorChooser color;
    public final PreviewPane previewer;
    public final ImageHandle image;
    public final ProgramPane pane;
    public final ToolToolbar toolbar;
    JMenu bgimage;
    JMenu sett;
    private JFrame sframe;
    private ScriptEngine js;

    public ProgramWindow() throws Exception {
        instance = this;
        System.out.println("Copyright 2011 Patrik Swedman");
        this.frame = new JFrame("SkinEdit - alpha 3 pre 7");
        this.frame.addWindowListener(this);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setResizable(false);
        this.pane = new ProgramPane(new BorderLayout());
        this.pane.setMessage("SkinEdit is loading...");
        this.frame.add(this.pane);
        this.frame.setSize(770, 717);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        if (!Settings.getInstance().getBoolean("hascheckedjavaversion", false)) {
            if (Launcher.JAVAVERSION < 5) {
                JOptionPane.showMessageDialog(this.frame, "You are using an unsupported java version. Please upgrade to Java 5 or newer (java 6 recomended)\n\nYor java version: Java " + Launcher.JAVAVERSION + "\n\nThis warning won't be displayed again.", "Warning", 2);
            } else if (Launcher.JAVAVERSION == 5) {
                JOptionPane.showMessageDialog(this.frame, "You are using Java 5. SkinEdit is running in compatabillity mode, all features may not work.\n\nThis warning won't be displayed again.", "Warning", 2);
            }
            Settings.getInstance().setProperty("hascheckedjavaversion", "true");
        }
        if (!Settings.getInstance().getBoolean("hasdisplayeddevmessage", false)) {
            JOptionPane.showMessageDialog(this.frame, "Welcome to SkinEdit.\n\nPlease note that you are using this at your own risk but if you have any problems I'd like to know.\n\nIf you prefered the controlls of the old SkinEdit versions check out the Multitool!\n\nAlso, if you have any problems with installing the previewer make sure the URL in the textbox is working, else replace it with the one from the forum.\nYou can also try moving SkinEdit to the desktop, this helps in many cases when the previewer can't be installed.\n\nFinally, just two tips:\n- There is help for some common problems in readme.txt\n- Before you post about an error in the forum, check the opening post if it has the solution, it is a lot faster then waiting for a reply.\n\n(This message won't be displayed again)", "Welcome to SkinEdit!", 1);
            Settings.getInstance().setProperty("hasdisplayeddevmessage", "true");
        }
        new Thread(new Runnable(){

            public void run() {
                if (Launcher.JAVAVERSION > 5) {
                    ProgramWindow.this.frame.setIconImages(ProgramIcon.getProgramIcons());
                } else {
                    ProgramWindow.this.frame.setIconImage(ProgramIcon.getProgramIcons().get(0));
                }
            }
        }).start();
        this.image = new ImageHandle();
        this.color = new TempColorChooser();
        this.previewer = new PreviewPane();
        this.editarea = new EditArea();
        JButton prewScr = new JButton("Take screenshot");
        prewScr.setActionCommand("previewscreenshot");
        prewScr.addActionListener(this);
        JPanel prewArea = new JPanel(new BorderLayout());
        prewArea.add((Component)this.previewer, "North");
        prewArea.add((Component)prewScr, "South");
        this.toolbar = ToolToolbar.setupToolbar();
        JPanel tbpane = new JPanel(new BorderLayout());
        tbpane.add((Component)this.toolbar, "North");
        tbpane.add((Component)this.editarea, "Center");
        this.pane.add((Component)prewArea, "East");
        this.pane.add((Component)this.color, "West");
        this.pane.add((Component)tbpane, "North");
        this.setupMenus();
        this.pane.removeMessage();
        this.frame.pack();
        Launcher.dbg("PROGRAM WINDOWSIZE " + this.frame.getSize());
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.previewer.start();
    }

    private void setupMenus() {
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File", true);
        JMenuItem filenew = new JMenuItem("New", 78);
        filenew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        filenew.setActionCommand("new");
        filenew.addActionListener(this);
        file.add(filenew);
        JMenuItem fileload = new JMenuItem("Load", 76);
        fileload.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileload.setActionCommand("load");
        fileload.addActionListener(this);
        file.add(fileload);
        JMenuItem filesave = new JMenuItem("Save", 83);
        filesave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        filesave.setActionCommand("save");
        filesave.addActionListener(this);
        file.add(filesave);
        JMenuItem filesaveas = new JMenuItem("Save As", 65);
        filesaveas.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        filesaveas.setActionCommand("saveas");
        filesaveas.addActionListener(this);
        file.add(filesaveas);
        file.addSeparator();
        JMenuItem fileexit = new JMenuItem("Exit", 69);
        fileexit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        fileexit.setActionCommand("exit");
        fileexit.addActionListener(this);
        file.add(fileexit);
        menu.add(file);
        JMenu edit = new JMenu("Edit");
        JMenuItem editundo = new JMenuItem("Undo", 85);
        editundo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        editundo.setActionCommand("undo");
        editundo.addActionListener(this);
        edit.add(editundo);
        JMenuItem editredo = new JMenuItem("Redo", 82);
        editredo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        editredo.setActionCommand("redo");
        editredo.addActionListener(this);
        edit.add(editredo);
        edit.addSeparator();
        JMenuItem editautoshade = new JMenuItem("Add noise", 65);
        editautoshade.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        editautoshade.setActionCommand("autoshade");
        editautoshade.addActionListener(this);
        edit.add(editautoshade);
        edit.addSeparator();
        JMenuItem editshowpicker = new JMenuItem("PartPicker", 80);
        editshowpicker.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        editshowpicker.setActionCommand("partpicker");
        editshowpicker.addActionListener(this);
        edit.add(editshowpicker);
        menu.add(edit);
        this.sett = new JMenu("Settings");
        JCheckBoxMenuItem bgfront = new JCheckBoxMenuItem("Draw background behind image", Settings.getInstance().getBoolean("drawbackgroundbehind", false));
        bgfront.setActionCommand("drawbgunder");
        bgfront.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        bgfront.addActionListener(this);
        this.sett.add(bgfront);
        JCheckBoxMenuItem prewold = new JCheckBoxMenuItem("Use old behavior for previewer", Settings.getInstance().getBoolean("useoldpreviewbehavior", false));
        prewold.setActionCommand("previewbehavior");
        prewold.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        prewold.addActionListener(this);
        this.sett.add(prewold);
        JMenu bgalpha = new JMenu("Background Alpha");
        ButtonGroup bgalphag = new ButtonGroup();
        RadioButtonWithValue<Float> nobgalpha = new RadioButtonWithValue<Float>("Do not draw background", Float.valueOf(0.0f));
        nobgalpha.setActionCommand("setbgalpha");
        nobgalpha.addActionListener(this);
        nobgalpha.setAccelerator(KeyStroke.getKeyStroke(521, 8));
        bgalphag.add(nobgalpha);
        bgalpha.add(nobgalpha);
        int acc = 49;
        for (float a = 0.1f; a < 1.0f; a += 0.1f) {
            RadioButtonWithValue<Float> cur = new RadioButtonWithValue<Float>((int)(a * 100.0f) + "%", Float.valueOf(a), Settings.getInstance().getFloat("backgroundalpha", 0.7f) == a);
            cur.setActionCommand("setbgalpha");
            if (acc <= 57) {
                cur.setAccelerator(KeyStroke.getKeyStroke(acc, 8));
                acc = (char)(acc + 1);
            }
            cur.addActionListener(this);
            bgalphag.add(cur);
            bgalpha.add(cur);
        }
        RadioButtonWithValue<Float> fullbgalpha = new RadioButtonWithValue<Float>("100%", Float.valueOf(1.0f));
        fullbgalpha.setActionCommand("setbgalpha");
        fullbgalpha.addActionListener(this);
        fullbgalpha.setAccelerator(KeyStroke.getKeyStroke(48, 8));
        bgalphag.add(fullbgalpha);
        bgalpha.add(fullbgalpha);
        this.sett.add(bgalpha);
        this.bgimage = new JMenu("Background Image");
        ButtonGroup bgimages = new ButtonGroup();
        JMenuItem bgcolor = new JMenuItem("Change background color", 98);
        bgcolor.setActionCommand("changebgcolor");
        bgcolor.addActionListener(this);
        this.sett.add(bgcolor);
        menu.add(this.sett);
        this.createBackgroundMenu();
        JMenu help = new JMenu("Help");
        JMenuItem helpabout = new JMenuItem("About", 65);
        helpabout.setActionCommand("about");
        helpabout.addActionListener(this);
        help.add(helpabout);
        JMenuItem helpcontrol = new JMenuItem("Controls", 67);
        helpcontrol.setActionCommand("control");
        helpcontrol.addActionListener(this);
        help.add(helpcontrol);
        menu.add(help);
        this.frame.setJMenuBar(menu);
    }

    private void createBackgroundMenu() {
        this.sett.remove(this.bgimage);
        this.bgimage = new JMenu("Background image");
        JMenuItem defimg = new JMenuItem("Default");
        defimg.setActionCommand("bgdefault");
        defimg.addActionListener(this);
        this.bgimage.add(defimg);
        File bgfolder = new File(Location.skinEdit() + File.separator + "backgrounds" + File.separator);
        System.out.println(bgfolder);
        if (bgfolder.exists() && bgfolder.isDirectory()) {
            this.bgimage.addSeparator();
            class ImageFileFilter
            implements FileFilter {
                private final String[] supported;

                public ImageFileFilter() {
                    if (Launcher.JAVAVERSION >= 6) {
                        ArrayList<String> tmp = new ArrayList<String>();
                        for (String s : ImageIO.getReaderFileSuffixes()) {
                            s = s.toLowerCase();
                            for (String h : tmp) {
                                if (!s.equals(h)) continue;
                            }
                            tmp.add(s);
                        }
                        this.supported = new String[tmp.size()];
                        for (int i = 0; i < tmp.size(); ++i) {
                            this.supported[i] = (String)tmp.get(i);
                        }
                    } else {
                        this.supported = new String[1];
                        this.supported[0] = "png";
                    }
                }

                public boolean accept(File pathname) {
                    if (!pathname.canRead() || !pathname.isFile()) {
                        return false;
                    }
                    String name = pathname.getName().toLowerCase();
                    for (String s : this.supported) {
                        if (!name.endsWith(s.toLowerCase())) continue;
                        try {
                            Image tmp = Toolkit.getDefaultToolkit().getImage(pathname.toURI().toURL());
                            while (tmp.getWidth(ProgramWindow.this.frame) == -1 || tmp.getHeight(ProgramWindow.this.frame) == -1) {
                            }
                            return tmp.getWidth(ProgramWindow.this.frame) % 64 == 0 && tmp.getHeight(ProgramWindow.this.frame) % 32 == 0;
                        }
                        catch (MalformedURLException ex) {
                            return false;
                        }
                    }
                    return false;
                }
            }
            for (File f : bgfolder.listFiles(new ImageFileFilter())) {
                VMenuItem c = new VMenuItem(f.getName(), f);
                c.addActionListener(this);
                c.setActionCommand("changebg");
                this.bgimage.add(c);
            }
        }
        this.bgimage.addSeparator();
        JMenuItem rel = new JMenuItem("Refresh list");
        rel.setActionCommand("reloadbgs");
        rel.addActionListener(this);
        this.bgimage.add(rel);
        this.sett.add(this.bgimage);
    }

    public void repaintAll() {
        this.editarea.repaint();
        this.previewer.setImage(this.image.getImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("load")) {
            this.image.showLoadImage();
        } else if (cmd.equals("save")) {
            this.image.saveImage();
        } else if (cmd.equals("saveas")) {
            this.image.showSaveImage();
        } else if (cmd.equals("new")) {
            this.image.showNewImage();
        } else if (cmd.equals("about")) {
            new AboutBox(this.frame);
        } else if (cmd.equals("exit")) {
            this.windowClosing(null);
        } else if (cmd.equals("drawbgunder")) {
            if (!(e.getSource() instanceof JCheckBoxMenuItem)) {
                return;
            }
            JCheckBoxMenuItem cur = (JCheckBoxMenuItem)e.getSource();
            Settings.getInstance().setProperty("drawbackgroundbehind", "" + cur.isSelected());
            this.editarea.repaint();
        } else if (cmd.equals("previewbehavior")) {
            if (!(e.getSource() instanceof JCheckBoxMenuItem)) {
                return;
            }
            JCheckBoxMenuItem cur = (JCheckBoxMenuItem)e.getSource();
            Settings.getInstance().setProperty("useoldpreviewbehavior", "" + cur.isSelected());
            this.previewer.setImage(this.image.getImage());
        } else if (cmd.equals("setbgalpha")) {
            if (!(e.getSource() instanceof RadioButtonWithValue)) {
                return;
            }
            RadioButtonWithValue cur = (RadioButtonWithValue)e.getSource();
            Settings.getInstance().setProperty("backgroundalpha", "" + cur.getValue());
            this.editarea.repaint();
        } else if (cmd.equals("undo")) {
            this.image.undo();
        } else if (cmd.equals("redo")) {
            this.image.redo();
        } else if (cmd.equals("changebgcolor")) {
            Color nev = JColorChooser.showDialog(this.frame, "Please select a new background color", Settings.getInstance().getColor("backgroundcolor", Color.GRAY));
            if (nev != null) {
                Settings.getInstance().setProperty("backgroundcolor", "" + nev.getRGB());
                this.editarea.repaint();
            }
        } else if (cmd.equals("control")) {
            new ControllsBox(this.frame);
        } else if (cmd.equals("bgdefault")) {
            Settings.getInstance().setProperty("backgroundimage", File.pathSeparator + "null" + File.pathSeparator);
            this.editarea.repaint();
        } else if (cmd.equals("changebg")) {
            if (!(e.getSource() instanceof VMenuItem)) {
                return;
            }
            try {
                VMenuItem v = (VMenuItem)e.getSource();
                Settings.getInstance().setProperty("backgroundimage", v.getValue().getCanonicalPath());
                this.editarea.repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (cmd.equals("reloadbgs")) {
            this.createBackgroundMenu();
        } else if (cmd.equals("autoshade")) {
            float force = (float)SliderOptionPane.show(this.frame) / 500.0f;
            Random r = new Random();
            this.image.addUndo();
            for (int x = 0; x < this.image.getImage().getWidth(); ++x) {
                for (int y = 0; y < this.image.getImage().getHeight(); ++y) {
                    float cur = r.nextFloat() * (force * 2.0f) - force;
                    this.image.getImage().shade(x, y, cur);
                }
            }
            this.repaintAll();
        } else if (cmd.equals("previewscreenshot")) {
            if (this.previewer.isBroken()) {
                JOptionPane.showMessageDialog(this.frame, "This button takes a screenshot of the previewer.\n\nThe previewer is currently disabled and therefore no screenshot can be taken.\nSorry. :(", "Screenshot", 2);
            } else {
                boolean paused = this.previewer.getPaused();
                this.previewer.setPaused(true);
                try {
                    BufferedImage img = this.previewer.getScreenshot(2.0, 2.0);
                    JFileChooser ch = new JFileChooser(Settings.getInstance().getProperty("lastscreenshotlocation", System.getProperty("user.dir")));
                    ch.setDialogType(1);
                    if (ch.showSaveDialog(this.frame) != 0) {
                        return;
                    }
                    File save = ch.getSelectedFile();
                    if (save == null) {
                        JOptionPane.showMessageDialog(this.frame, "Invalid filename!", "Error saving file", 0);
                        Settings.getInstance().setProperty("lastscreenshotlocation", save.getParentFile().getCanonicalPath());
                        return;
                    }
                    if (!save.getAbsolutePath().toLowerCase().endsWith(".png")) {
                        System.out.println("Appended .png to screenshot filename");
                        save = new File(save.getAbsolutePath() + ".png");
                    }
                    if (!save.canWrite() && save.exists()) {
                        JOptionPane.showMessageDialog(this.frame, "File exists already and can't be overwritten", "Error saving file", 0);
                        return;
                    }
                    if (save.exists() && JOptionPane.showConfirmDialog(this.frame, "The file already exists.\nDo you want to overwrite the old file?", "Overwrite", 0, 3) == 1) {
                        return;
                    }
                    ImageIO.write((RenderedImage)img, "png", save);
                }
                catch (IOException ex) {
                    ErrorScreen.addError(ex, "Error saving previewer screenshot");
                }
                finally {
                    this.previewer.setPaused(paused);
                }
            }
        } else if (cmd.equals("partpicker")) {
            PartsPicker.show(this.frame, this.image.getImage());
            this.repaintAll();
        } else {
            if (cmd.equals("changetoolman")) {
                // empty if block
            }
            if (cmd.equals("dev")) {
                // empty if block
            }
            ErrorScreen.addError("Warning: Unknown actioncommand: " + e.getActionCommand());
            System.err.println("Warning: Unknown actioncommand: " + e.getActionCommand() + "! (please report this)");
        }
    }

    private void scriptWindow() {
        if (this.sframe == null) {
            this.sframe = new JFrame("SkinEdit JS");
            this.sframe.setLayout(new BorderLayout());
            final JTextArea stext = new JTextArea(20, 35);
            stext.setLineWrap(false);
            stext.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && e.isControlDown()) {
                        try {
                            System.out.println("[JS] Running code...");
                            Object out = ProgramWindow.this.js.eval(stext.getText());
                            if (out != null) {
                                System.out.println("[JS] Output: " + out.toString());
                            }
                            if (!e.isAltDown()) {
                                stext.setText("");
                            }
                            System.out.println("[JS] ___________________");
                        }
                        catch (ScriptException ex) {
                            System.err.println("[JS] Script error:");
                            ex.printStackTrace();
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            this.sframe.add(new JScrollPane(stext));
            this.sframe.setDefaultCloseOperation(1);
            this.sframe.pack();
            this.js = new ScriptEngineManager().getEngineByExtension("js");
            this.js.put("pw", this);
        }
        this.sframe.setVisible(true);
    }

    public void windowClosing(WindowEvent e) {
        if (this.image.isImageSaved()) {
            if (this.previewer != null) {
                this.previewer.stop();
            }
            System.exit(0);
        } else {
            int res = JOptionPane.showConfirmDialog(this.frame, "You've got unsaved changes.\n\nDo you want to save your changes?", "Confirm", 1);
            if (res == 0) {
                this.image.showSaveImage();
            } else if (res == 1) {
                if (this.previewer != null) {
                    this.previewer.stop();
                }
                System.exit(0);
            }
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

