/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import swedtech.mcskinedit.Launcher;

public class MyColorChooser
extends JComponent
implements MouseListener {
    private Color main = Color.BLACK;
    private Color back = Color.WHITE;
    private Color[] history = new Color[16];

    public MyColorChooser() {
        this.setPreferredSize(new Dimension(236, 66));
        this.addMouseListener(this);
        for (int i = 0; i < this.history.length; ++i) {
            this.history[i] = Color.WHITE;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        g.setColor(this.back);
        g.fill3DRect(25, 25, 30, 30, true);
        g.setColor(this.main);
        g.fill3DRect(10, 10, 30, 30, true);
        for (int i = 0; i < 8; ++i) {
            g.setColor(this.history[i]);
            g.fill3DRect(66 + i * 20, 15, 16, 16, true);
            g.setColor(this.history[i + 8]);
            g.fill3DRect(66 + i * 20, 35, 16, 16, true);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            Color t = JColorChooser.showDialog(this, "Select a new color", this.main);
            if (t != null) {
                this.main = t;
            }
            this.addHistory(t);
        } else if (e.getButton() == 3) {
            Launcher.dbg("secondary");
            Color t = JColorChooser.showDialog(this, "Select a new color", this.back);
            if (t != null) {
                this.back = t;
            }
            this.addHistory(t);
        }
    }

    private void addHistory(Color c) {
        int i;
        for (i = 0; i < this.history.length; ++i) {
            if (!this.history[i].equals(c)) continue;
            for (int j = i; j > 0; --j) {
                this.history[j] = this.history[j - 1];
            }
            this.history[0] = c;
            this.repaint();
            return;
        }
        for (i = this.history.length - 1; i > 0; --i) {
            this.history[i] = this.history[i - 1];
        }
        this.history[0] = c;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

