/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.frames.ProgramWindow;
import swedtech.mcskinedit.icons.ProgramIcon;
import swedtech.mcskinedit.tools.Tool;
import swedtech.mcskinedit.tools.ToolCursor;

public class PenTool
implements Tool {
    JPanel settings = new JPanel();
    ToolCursor cursor;
    JSlider brushsize = new JSlider(1, 12, Math.min(12, Math.max(1, Settings.getInstance().getInteger("pensize", 1))));
    JLabel text = new JLabel("1");
    private ProgramWindow pw = ProgramWindow.instance;

    public PenTool() {
        this.settings.setLayout(new BorderLayout());
        this.brushsize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PenTool.this.text.setText(PenTool.this.brushsize.getValue() + "");
                Settings.getInstance().put("pensize", "" + PenTool.this.brushsize.getValue());
            }
        });
        this.settings.add((Component)this.brushsize, "Center");
        this.settings.add((Component)this.text, "East");
    }

    public JComponent getSettings() {
        return this.settings;
    }

    public Icon getIcon() {
        return ProgramIcon.getToolIcon("pen");
    }

    public String getName() {
        return "Pen";
    }

    public void doPrimary(Point p) {
        this.process(p, this.pw.color.getMain());
    }

    public void doSecondary(Point p) {
        this.process(p, this.pw.color.getAlt());
    }

    private void process(Point org, Color c) {
        int scale = ProgramWindow.instance.editarea.getScale();
        this.fillRectangle(org.x / scale - this.brushsize.getValue() / 2, org.y / scale - this.brushsize.getValue() / 2, this.brushsize.getValue(), c);
        this.pw.repaintAll();
    }

    private void fillRectangle(int x, int y, int size, Color c) {
        for (int i = x; i < size + x; ++i) {
            for (int j = y; j < size + y; ++j) {
                this.pw.image.getImage().set(i, j, c);
            }
        }
    }

    public boolean allowDrag() {
        return true;
    }

    public int getSize() {
        return this.brushsize.getValue();
    }
}

