/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.classes;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.classes.BitImage;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.frames.ProgramWindow;

public class ImageHandle {
    private BitImage current;
    private final Vector<BitImage> undos;
    private final Vector<BitImage> redos;
    private final ProgramWindow pw = ProgramWindow.instance;
    private File filename;
    private boolean imageSaved = true;

    public ImageHandle() {
        this.current = new BitImage(64, 32);
        this.undos = new Vector();
        this.redos = new Vector();
    }

    public void addUndo() {
        try {
            BitImage last = this.undos.lastElement();
            if (last.equals(this.current)) {
                Launcher.dbg("Prevented duplicate undo");
                return;
            }
        }
        catch (NoSuchElementException ex) {
            System.out.println("No previous undo to compare with.");
        }
        System.out.println("New undo added");
        this.undos.add(new BitImage(this.current));
        this.redos.clear();
    }

    public void undo() {
        if (this.undos.size() > 0) {
            System.out.println("Undid!");
            this.redos.add(this.current);
            this.current = this.undos.remove(this.undos.size() - 1);
            this.pw.repaintAll();
        } else {
            System.out.println("Nothing to undo!");
        }
    }

    public void redo() {
        if (this.redos.size() > 0) {
            this.undos.add(this.current);
            this.current = this.redos.remove(this.redos.size() - 1);
            this.pw.repaintAll();
        } else {
            System.out.println("Nothing to redo!");
        }
    }

    public BitImage getImage() {
        return this.current;
    }

    public void setImage(BitImage image) {
        this.current = image;
    }

    public void reset() {
        this.current.clear();
        this.undos.clear();
        this.redos.clear();
        this.setFilename(null);
        this.pw.repaintAll();
        this.setImageSaved(true);
    }

    public void saveImage() {
        if (this.getFilename() == null) {
            this.showSaveImage();
            return;
        }
        this.saveImage(this.getFilename());
    }

    public String saveImage(File file) {
        try {
            boolean ret = ImageIO.write((RenderedImage)this.current.getImage(1.0f), "png", file);
            if (ret) {
                this.setFilename(file);
                this.setImageSaved(true);
                return null;
            }
            return "Unable to write file (No permission?)";
        }
        catch (Exception ex) {
            return "The system returned the following error: " + ex.getMessage();
        }
    }

    public void showLoadImage() {
        JFileChooser fc = new JFileChooser(Settings.getInstance().getProperty("lastfilelocation", System.getProperty("user.dir")));
        if (fc.showOpenDialog(fc) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.pw.frame, "The file doesn't exist.");
            return;
        }
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(this.pw.frame, "The file exist but isn't readable.");
            return;
        }
        String res = this.loadImage(file);
        if (res != null) {
            JOptionPane.showMessageDialog(this.pw.frame, "The following error occured loading the image:\n" + res);
        }
    }

    public void showNewImage() {
        if (JOptionPane.showConfirmDialog(this.pw.frame, "Are you sure you want to create a new image. All unsaved changes will be lost!", "Confirm", 0) == 0) {
            this.reset();
        }
    }

    public void showSaveImage() {
        JFileChooser fc = new JFileChooser(Settings.getInstance().getProperty("lastfilelocation", System.getProperty("user.dir")));
        if (fc.showSaveDialog(fc) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.getAbsolutePath().toLowerCase().endsWith(".png")) {
            System.out.println("Appended .png to the filename");
            file = new File(file.getAbsolutePath() + ".png");
        }
        if (file.canWrite() && JOptionPane.showConfirmDialog(this.pw.frame, "The file exists. Overwrite?", "Confirm", 0) != 0) {
            return;
        }
        if (file.exists() && !file.canWrite()) {
            JOptionPane.showMessageDialog(this.pw.frame, "The file already exists and can not be overwritten.");
            return;
        }
        if (this.saveImage(file) != null) {
            JOptionPane.showMessageDialog(this.pw.frame, "Error! Couldn't save file!");
        }
    }

    public String loadImage(File file) {
        try {
            if (!this.isSupportedFormat(file.getName())) {
                return "Unrecognized image format";
            }
            Image load = Toolkit.getDefaultToolkit().createImage(file.toURI().toURL());
            while (load.getWidth(this.pw.frame) == -1) {
            }
            if (load.getWidth(this.pw.frame) != 64 || load.getHeight(this.pw.frame) != 32) {
                return "Image is not 64x32 pixels";
            }
            int[] pixels = new int[2048];
            PixelGrabber grabber = new PixelGrabber(load, 0, 0, 64, 32, pixels, 0, 64);
            grabber.grabPixels(0L);
            for (int i = 0; i < 2048; ++i) {
                int yy = i / 64;
                this.current.set(i - yy * 64, yy, new Color(pixels[i], true));
            }
            this.setFilename(file);
            this.undos.clear();
            this.redos.clear();
            this.pw.repaintAll();
            this.setImageSaved(true);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "The system returned the following error: " + ex.getMessage();
        }
    }

    private boolean isSupportedFormat(String format) {
        String[] data = ImageIO.getReaderFileSuffixes();
        for (int i = 0; i < data.length; ++i) {
            if (!format.toLowerCase().endsWith(data[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public File getFilename() {
        return this.filename;
    }

    public void setFilename(File filename) {
        this.filename = filename;
    }

    public boolean isImageSaved() {
        return this.imageSaved;
    }

    public void setImageSaved(boolean imageSaved) {
        this.imageSaved = imageSaved;
    }
}

