/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.classes;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import swedtech.mcskinedit.frames.ErrorScreen;

public class PNGFilenameFilter
implements FilenameFilter {
    private boolean checksize;

    public PNGFilenameFilter() {
        this.checksize = true;
    }

    public PNGFilenameFilter(boolean checksize) {
        this.checksize = checksize;
    }

    public boolean accept(File dir, String name) {
        if (this.checksize && name.toLowerCase().endsWith(".png")) {
            try {
                Image i = Toolkit.getDefaultToolkit().getImage(dir.getCanonicalPath() + File.separator + name);
                System.out.print("Loading image (" + name + ")");
                while (i.getHeight(null) == -1 || i.getWidth(null) == -1) {
                    System.out.print('.');
                }
                System.out.println(" Done!");
                return i.getHeight(null) == 32 && i.getWidth(null) == 64;
            }
            catch (IOException ex) {
                ErrorScreen.addError(ex, "Error loading image to PartPicker");
                return false;
            }
        }
        return name.toLowerCase().endsWith(".png");
    }
}

