/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.panels;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.frames.ErrorScreen;
import swedtech.mcskinedit.frames.ProgramWindow;
import swedtech.mcskinedit.tools.Tool;
import swedtech.mcskinedit.tools.ToolHandler;

public class EditArea
extends JComponent
implements MouseMotionListener,
MouseListener {
    private Tool tool;
    private int scale = 10;
    public boolean creeper = false;
    private ArrayList<ChangeListener> toolChangeListeners = new ArrayList();
    private Point mouseLocation = new Point(1, 1);
    private Image bg;
    private String bgfile;
    private int holding = -1;

    public EditArea() {
        this.setPreferredSize(new Dimension(640, 320));
        this.setTool("Pen");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Color bgcol = new Color(Settings.getInstance().getInteger("backgroundcolor", Color.GRAY.getRGB()));
        g.setColor(bgcol.darker());
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(bgcol);
        g.fillRect(0, 0, ProgramWindow.instance.image.getImage().getWidth() * this.scale, ProgramWindow.instance.image.getImage().getHeight() * this.scale);
        if (Settings.getInstance().getBoolean("drawbackgroundbehind", false)) {
            this.drawBackground(g);
        }
        g.drawImage((Image)ProgramWindow.instance.image.getImage().getImage(this.getScale()), 0, 0, this);
        if (!Settings.getInstance().getBoolean("drawbackgroundbehind", false)) {
            this.drawBackground(g);
        }
        if (this.mouseLocation != null) {
            int mousex = this.mouseLocation.x / this.scale;
            int mousey = this.mouseLocation.y / this.scale;
            int size = this.getTool().getSize();
            g.setColor(ProgramWindow.instance.color.getMain());
            g.fillRect(mousex * this.scale - size / 2 * this.scale, mousey * this.scale - size / 2 * this.scale, this.scale * size, this.scale * size);
        }
    }

    private void drawBackground(Graphics2D g) {
        Composite old = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, Settings.getInstance().getFloat("backgroundalpha", 0.2f)));
        g.drawImage(this.getBackgroundImage(), 0, 0, this);
        g.setComposite(old);
    }

    private Image getBackgroundImage() {
        String str = Settings.getInstance().getProperty("backgroundimage", null);
        if (this.bg == null || str == null && this.bgfile == null || !str.equals(this.bgfile)) {
            if (str == null || !new File(str).canRead()) {
                this.bg = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("background.png"));
                return this.bg;
            }
            this.bgfile = str;
            this.bg = Toolkit.getDefaultToolkit().getImage(str);
            return this.bg;
        }
        return this.bg;
    }

    public void setTool(String name) {
        Tool t = ToolHandler.getTool(name);
        if (t == null) {
            ErrorScreen.addError("Tried to set to a NULL tool! (" + name + ")");
            return;
        }
        Launcher.dbg("Tool is now " + t.getName() + "!");
        this.tool = t;
        for (ChangeListener c : this.toolChangeListeners) {
            c.stateChanged(new ChangeEvent(this));
        }
    }

    public Tool getTool() {
        return this.tool;
    }

    public void addToolChangeListener(ChangeListener c) {
        this.toolChangeListeners.add(c);
    }

    public boolean removeToolChangeListener(ChangeListener c) {
        return this.toolChangeListeners.remove(c);
    }

    public void removeAllToolChangeListeners() {
        this.toolChangeListeners = new ArrayList();
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.tool.allowDrag()) {
            this.process(e.getPoint(), this.holding);
        }
        if (this.mouseLocation != null) {
            this.mouseLocation = e.getPoint();
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.mouseLocation != null) {
            this.mouseLocation = e.getPoint();
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseLocation = e.getPoint();
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseLocation = null;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        this.process(e.getPoint(), e.getButton());
    }

    public void mousePressed(MouseEvent e) {
        ProgramWindow.instance.image.addUndo();
        ProgramWindow.instance.image.setImageSaved(false);
        this.holding = e.getButton();
    }

    public void mouseReleased(MouseEvent e) {
        this.holding = -1;
    }

    public void process(Point p, int button) {
        if (button == -1) {
            Launcher.dbg("Button -1!!!");
        } else if (button == 1) {
            Launcher.dbg("Used primary...");
            this.tool.doPrimary(p);
            ProgramWindow.instance.repaintAll();
        } else if (button == 3) {
            Launcher.dbg("Used secondary...");
            this.tool.doSecondary(p);
            ProgramWindow.instance.repaintAll();
        } else {
            Launcher.dbg("Used unknown button...");
        }
    }
}

