/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.panels;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import swedtech.mcskinedit.classes.BitImage;
import swedtech.mcskinedit.classes.Location;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.frames.ErrorScreen;
import swedtech.mcskinedit.offlinemode.HTTPServer;

public class PreviewPane
extends JPanel {
    private static final String JARDOWNLOADURL = "http://gf.web44.net/skinedit/skintest2.jar";
    private final String DEFAULTSKIN = "http://www.minecraft.net/img/char.png";
    private static final String MODELPREVIEW = "net.minecraft.skintest.ModelPreview";
    private static final String ZOMBIE = "net.minecraft.skintest.math.Zombie";
    private static final String BITMAP = "net.minecraft.skintest.gfx.Bitmap";
    private static final String SCREENBITMAP = "net.minecraft.skintest.gfx.ImageBitmap";
    private File jar = new File(Location.skinEdit() + File.separator + "skintest2.jar");
    private Method bitMapSetPixels;
    private Object bitmapObj;
    private Canvas modelPreviewObj;
    private Class modelPreview;
    private Class screenBitmapClass;
    private Object screenBitmapObj;
    private Field screenBitmapField;
    private Field pausedField;
    private boolean broken;
    private boolean started;

    public PreviewPane() {
        this(2);
    }

    public PreviewPane(int scale) {
        this.setPreferredSize(new Dimension(scale * 160, scale * 160));
        if (Settings.getInstance().getBoolean("disable3dpreview", false)) {
            return;
        }
        if (!this.jar.exists() && !this.getJar()) {
            return;
        }
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{this.jar.toURI().toURL()});
            this.modelPreview = loader.loadClass(MODELPREVIEW);
            Class<?> zombie = loader.loadClass(ZOMBIE);
            Class<?> bitmap = loader.loadClass(BITMAP);
            this.screenBitmapClass = loader.loadClass(SCREENBITMAP);
            int port = new HTTPServer().startServer();
            String url = port != -1 ? "http://localhost:" + port : "http://www.minecraft.net/img/char.png";
            this.modelPreviewObj = (Canvas)this.modelPreview.getConstructors()[0].newInstance(scale, url);
            Field zombieField = this.modelPreview.getDeclaredField("zombie");
            zombieField.setAccessible(true);
            Object zombieObj = zombieField.get(this.modelPreviewObj);
            Field bitmapField = zombie.getDeclaredField("texture");
            while ((this.bitmapObj = bitmapField.get(zombieObj)) == null) {
            }
            int[] arg = new int[]{};
            this.bitMapSetPixels = bitmap.getDeclaredMethod("setPixels", arg.getClass());
            this.bitMapSetPixels.setAccessible(true);
            this.add(this.modelPreviewObj);
        }
        catch (Exception ex) {
            this.broken = true;
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Preview functionallity corrupted!\n\nTry downloading \"skintest2.jar\" manually!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getJar() {
        BufferedOutputStream file;
        try {
            FileOutputStream fos = new FileOutputStream(this.jar);
            file = new BufferedOutputStream(fos);
        }
        catch (Exception ex) {
            if (ex instanceof FileNotFoundException && ex.getMessage() != null) {
                JOptionPane.showMessageDialog(this, "Previewer can't be installed because SkinEdit doesn't have permission to write to skintest2.jar\n\nPlease move SkinEdit to a folder without permission restriction.", "Error", 0);
            } else {
                ErrorScreen.addError(ex, "Error creating skintest2.jar (previewer)");
            }
            this.jar.delete();
            this.broken = true;
            return false;
        }
        JFrame feed = new JFrame("SkinEdit - alpha 3 pre 7 downloader");
        JPanel pane = new JPanel(new BorderLayout());
        JLabel text = new JLabel("Please wait...");
        JProgressBar bar = new JProgressBar(0, 100);
        feed.add(pane);
        pane.add((Component)text, "North");
        pane.add((Component)bar, "South");
        feed.setDefaultCloseOperation(3);
        bar.setStringPainted(true);
        feed.setResizable(false);
        feed.pack();
        feed.setLocationRelativeTo(null);
        feed.setVisible(true);
        String loc = "No download location specified!";
        try {
            boolean cur;
            loc = JOptionPane.showInputDialog(feed, "The preview library doesn't exist! Please select the URL to download it:", JARDOWNLOADURL);
            if (loc == null) {
                this.broken = true;
                boolean bl = false;
                return bl;
            }
            bar.setIndeterminate(true);
            text.setText("Connecting...");
            URL url = new URL(loc);
            URLConnection cnct = url.openConnection();
            BufferedInputStream stream = new BufferedInputStream(cnct.getInputStream());
            bar.setIndeterminate(false);
            text.setText("Downloading...");
            Vector<Integer> data = new Vector<Integer>();
            boolean showPer = true;
            if (cnct.getContentLength() == -1) {
                showPer = false;
                bar.setIndeterminate(true);
            } else {
                bar.setIndeterminate(false);
            }
            int dl = 0;
            while (!(cur = stream.read())) {
                data.add(cur ? 1 : 0);
                if (!showPer || dl % 100 != 0) continue;
                bar.setValue((int)((float)(++dl) / (float)cnct.getContentLength() * 100.0f));
            }
            stream.close();
            if (data.size() == 0) {
                this.broken = true;
                JOptionPane.showMessageDialog(feed, "There was an error downloading the previewer.\n\nThis is usually because the webpage where the previewer is downloaded from is offline.\n\nYou tried to download from:\n" + loc, "Error downloading previewer", 0);
                cur = false;
                return cur;
            }
            text.setText("Saving file...");
            bar.setIndeterminate(true);
            try {
                for (int i = 0; i < data.size(); ++i) {
                    file.write((Integer)data.get(i));
                }
                file.close();
            }
            catch (IOException ex) {
                this.jar.delete();
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Previewer can't be installed because SkinEdit doesn't have permission to write to skintest2.jar\n\nPlease move SkinEdit to a folder without permission restriction.", "Error", 0);
                this.broken = true;
                boolean bl = false;
                feed.setVisible(false);
                feed.dispose();
                return bl;
            }
            text.setText("Dowload complete!");
            bar.setIndeterminate(false);
            bar.setValue(100);
            bar.setString("Complete!");
            JOptionPane.showMessageDialog(feed, "Preview functionallity downloaded successfully!");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.jar.delete();
            this.broken = true;
            ex.printStackTrace();
            JOptionPane.showMessageDialog(feed, "There was an error downloading the previewer.\n\nThis is usually because the webpage where the previewer is downloaded from is offline.\n\nYou tried to download from:\n" + loc, "Error downloading previewer", 0);
            boolean bl = false;
            return bl;
        }
        finally {
            feed.setVisible(false);
            feed.dispose();
        }
    }

    public void start() {
        if (this.broken) {
            return;
        }
        try {
            this.modelPreview.getDeclaredMethod("start", new Class[0]).invoke((Object)this.modelPreviewObj, new Object[0]);
            this.started = true;
        }
        catch (Exception ex) {
            this.broken = true;
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Preview functionallity corrupted!\n\nTry downloading \"skintest2.jar\" manually!");
        }
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void stop() {
        if (this.broken) {
            return;
        }
        try {
            this.modelPreview.getDeclaredMethod("stop", new Class[0]).invoke((Object)this.modelPreviewObj, new Object[0]);
            this.started = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setImage(int[] img) {
        if (!this.started) {
            return;
        }
        try {
            this.bitMapSetPixels.invoke(this.bitmapObj, new Object[]{img});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setImage(BitImage img) {
        this.setImage(img.getImageAsPreviewArray());
    }

    public void paint(Graphics g) {
        if (!this.broken) {
            super.paint(g);
        } else {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            FontMetrics fm = this.getFontMetrics(g.getFont());
            String error = "Preview broken";
            g.setColor(Color.red);
            g.drawString(error, this.getSize().width / 2 - fm.stringWidth(error) / 2, this.getSize().height / 2 + fm.getHeight() / 2);
        }
    }

    public String canvasSize() {
        return "MODELPREVIEWOBJ: " + this.modelPreviewObj.getSize() + "\n" + "THIS: " + this.getSize();
    }

    public BufferedImage getScreenshot() {
        if (this.broken) {
            return null;
        }
        try {
            if (this.screenBitmapField == null) {
                this.screenBitmapField = this.modelPreview.getDeclaredField("screenBitmap");
                this.screenBitmapField.setAccessible(true);
            }
            if (this.screenBitmapObj == null) {
                this.screenBitmapObj = this.screenBitmapField.get(this.modelPreviewObj);
            }
            return (BufferedImage)this.screenBitmapClass.getMethod("getImage", new Class[0]).invoke(this.screenBitmapObj, new Object[0]);
        }
        catch (Exception ex) {
            ErrorScreen.addError(ex, "Failed to grab previewer screenshot");
            return null;
        }
    }

    public BufferedImage getScreenshot(double scaleY, double scaleX) {
        if (this.broken) {
            return null;
        }
        BufferedImage sc = this.getScreenshot();
        BufferedImage ret = new BufferedImage((int)(160.0 * scaleX), (int)(160.0 * scaleY), 2);
        ret.getGraphics().drawImage(sc, 0, 0, (int)(160.0 * scaleX), (int)(160.0 * scaleY), this);
        return ret;
    }

    public boolean setPaused(boolean bool) {
        if (this.broken) {
            return false;
        }
        try {
            if (this.pausedField == null) {
                this.pausedField = this.modelPreview.getDeclaredField("paused");
                this.pausedField.setAccessible(true);
            }
            this.pausedField.setBoolean(this.modelPreviewObj, bool);
            return true;
        }
        catch (Exception ex) {
            ErrorScreen.addError(ex, "Failed to pause/unpause previewer");
            return false;
        }
    }

    public boolean getPaused() {
        if (this.broken) {
            return false;
        }
        try {
            if (this.pausedField == null) {
                this.pausedField = this.modelPreview.getDeclaredField("paused");
                this.pausedField.setAccessible(true);
            }
            return this.pausedField.getBoolean(this.modelPreviewObj);
        }
        catch (Exception ex) {
            ErrorScreen.addError(ex, "Failed read current pause on previewer");
            return false;
        }
    }
}

