/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.panels;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.frames.ProgramWindow;
import swedtech.mcskinedit.panels.PreviewPane;

public class ProgramPane
extends JPanel {
    private String msg;

    public ProgramPane() {
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
    }

    public ProgramPane(LayoutManager mng) {
        super(mng);
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        String tmsg = this.msg;
        if (tmsg != null) {
            Graphics2D g = (Graphics2D)graphics;
            Composite old = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 0.35f));
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setComposite(old);
            Font oldf = g.getFont();
            g.setFont(new Font("SansSerif", 1, 28));
            FontMetrics fm = g.getFontMetrics();
            int x = this.getSize().width / 2 - fm.stringWidth(tmsg) / 2;
            int y = this.getSize().height / 2 + fm.getHeight() / 2 - fm.getDescent();
            g.drawString(tmsg, x + 1, y + 1);
            g.setColor(this.getForeground());
            g.drawString(tmsg, x - 1, y - 1);
            g.setFont(oldf);
            g.dispose();
        }
        graphics.dispose();
    }

    public void setMessage(String msg) {
        PreviewPane pw = ProgramWindow.instance.previewer;
        if (msg == null && this.msg != null && pw != null) {
            Launcher.dbg("Showing previewer");
            pw.start();
        } else if (this.msg == null && msg != null && pw != null) {
            Launcher.dbg("Hiding previewer");
            pw.stop();
        }
        Launcher.dbg("Changed message from \"" + this.msg + "\" to \"" + msg + "\"");
        this.msg = msg;
        this.repaint();
    }

    public void removeMessage() {
        this.setMessage(null);
        this.repaint();
    }

    public String getMessage() {
        return this.msg;
    }
}

