/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.classes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.frames.ErrorScreen;

public class BitImage {
    private final Color[][] image;
    private final int WIDTH;
    private final int HEIGTH;

    public BitImage(int width, int height) {
        this(width, height, new Color(0, 0, 0, 0));
    }

    public BitImage(int width, int height, Color def) {
        this.WIDTH = width;
        this.HEIGTH = height;
        this.image = new Color[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.image[x][y] = def;
            }
        }
    }

    public BitImage(BitImage org) {
        this.HEIGTH = org.getHeight();
        this.WIDTH = org.getWidth();
        this.image = new Color[this.WIDTH][this.HEIGTH];
        for (int x = 0; x < this.WIDTH; ++x) {
            for (int y = 0; y < this.HEIGTH; ++y) {
                this.image[x][y] = org.get(x, y);
            }
        }
    }

    public void append(BitImage img) {
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                if (img.get(x, y).getAlpha() <= 0) continue;
                this.set(x, y, img.get(x, y));
            }
        }
    }

    public BitImage addAlpha(BitImage img) {
        return null;
    }

    public boolean isInside(int x, int y) {
        return this.isInside(new Point(x, y));
    }

    public boolean isInside(Point p) {
        return p.x >= 0 && p.x < this.getWidth() && p.y >= 0 && p.y < this.getHeight();
    }

    public void set(int x, int y, Color c) {
        if (x < 0 || x > this.getWidth() - 1 || y < 0 || y > this.getHeight() - 1) {
            return;
        }
        this.image[x][y] = c;
    }

    public Color get(int x, int y) {
        if (x < 0 || x > this.getWidth() - 1 || y < 0 || y > this.getHeight() - 1) {
            return null;
        }
        return this.image[x][y];
    }

    public void shade(int x, int y, float ammount) {
        if (!this.isInside(x, y)) {
            return;
        }
        Color old = this.image[x][y];
        if (old.getAlpha() == 0) {
            return;
        }
        float[] ne = new float[3];
        Color.RGBtoHSB(old.getRed(), old.getBlue(), old.getGreen(), ne);
        ne[2] = Math.max(Math.min(1.0f, ne[2] + ammount), 0.0f);
        this.image[x][y] = Color.getHSBColor(-ne[0], ne[1], ne[2]);
    }

    public void drawLine(Point p1, Point p2, Color color) {
        block3: {
            int dy;
            int dx;
            block2: {
                dx = p2.x - p1.x;
                dy = p2.y - p1.y;
                this.set(p1.x, p1.y, color);
                if (Math.abs(dx) <= Math.abs(dy)) break block2;
                float m = (float)dy / (float)dx;
                float b = (float)p1.y - m * (float)p1.x;
                int n = dx = dx < 0 ? -1 : 1;
                while (p1.x != p2.x) {
                    p1.x += dx;
                    this.set(p1.x, Math.round(m * (float)p1.x + b), color);
                }
                break block3;
            }
            if (dy == 0) break block3;
            float m = (float)dx / (float)dy;
            float b = (float)p1.x - m * (float)p1.y;
            int n = dy = dy < 0 ? -1 : 1;
            while (p1.y != p2.y) {
                p1.y += dy;
                this.set(Math.round(m * (float)p1.y + b), p1.y, color);
            }
        }
    }

    public void floodFill(int x, int y, Color replacement) {
        this.floodFill(x, y, replacement, this.image[x][y]);
    }

    private void floodFill(int x, int y, Color replacement, Color replace) {
        if (!this.isInside(x, y) || replacement.equals(replace)) {
            return;
        }
        if (this.image[x][y].equals(replace)) {
            this.image[x][y] = replacement;
            this.floodFill(x - 1, y, replacement, replace);
            this.floodFill(x + 1, y, replacement, replace);
            this.floodFill(x, y + 1, replacement, replace);
            this.floodFill(x, y - 1, replacement, replace);
        }
    }

    public void clear() {
        this.clear(new Color(0, 0, 0, 0));
    }

    public void clear(Color color) {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                this.set(x, y, color);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitImage)) {
            return false;
        }
        BitImage img = (BitImage)o;
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getHeight()) {
            return false;
        }
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (img.get(x, y).equals(this.get(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Arrays.deepHashCode((Object[])this.image);
        return hash;
    }

    public BufferedImage getImage() {
        return this.getImage(1.0f);
    }

    public BufferedImage getImage(float scale) {
        BufferedImage img = new BufferedImage((int)((float)this.getWidth() * scale), (int)((float)this.getHeight() * scale), 2);
        Graphics2D g = img.createGraphics();
        for (float x = 0.0f; x < (float)this.getWidth(); x += 1.0f) {
            for (float y = 0.0f; y < (float)this.getHeight(); y += 1.0f) {
                g.setColor(this.image[(int)x][(int)y]);
                g.fillRect((int)(x * scale), (int)(y * scale), (int)scale, (int)scale);
            }
        }
        g.dispose();
        return img;
    }

    public static BitImage getFromFile(URL url) {
        return BitImage.getFromFile(Toolkit.getDefaultToolkit().getImage(url));
    }

    private static BitImage getFromFile(Image img) {
        System.out.print("Loading image");
        while (img.getWidth(null) == -1 || img.getHeight(null) == -1) {
            System.out.print('.');
        }
        System.out.println(" Done!");
        int[] colors = new int[img.getWidth(null) * img.getHeight(null)];
        PixelGrabber g = new PixelGrabber(img, 0, 0, -1, -1, colors, 0, img.getWidth(null));
        try {
            System.out.print("Loading image... ");
            if (!g.grabPixels(0L)) {
                ErrorScreen.addError("For some wonderful reason it appears that g.grabPizels returned false... Great, just great...");
                System.out.println("Failed!");
                return null;
            }
            System.out.println("Loaded!");
        }
        catch (InterruptedException ex) {
            ErrorScreen.addError(ex, "Failed to something at getFromFile (can this error even happen? Apparantly...)");
            System.out.println("Failed!");
            return null;
        }
        BitImage bit = new BitImage(g.getWidth(), g.getHeight());
        for (int x = 0; x < g.getWidth(); ++x) {
            for (int y = 0; y < g.getHeight(); ++y) {
                Color c = new Color(colors[y * g.getWidth() + x], true);
                bit.set(x, y, c);
            }
        }
        return bit;
    }

    public void saveToFile(final File file) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    ImageIO.write((RenderedImage)BitImage.this.getImage(2.0f), "png", file);
                }
                catch (IOException ex) {
                    ErrorScreen.addError(ex, "You'll never guess but the file saving crashed, but SkinEdit will survive!");
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    public int[] getImageAsPreviewArray() {
        if (Settings.getInstance().getBoolean("useoldpreviewbehavior", false)) {
            return this.getImageAsSingleArray();
        }
        return this.getImageAsMinecraftArray();
    }

    public int[] getImageAsMinecraftArray() {
        BitImage com = new BitImage(this);
        if (!com.supportsMChat()) {
            com.removeMCHat();
        }
        com.removeMCAlpha();
        return BitImage.getImageAsSingleArray(com);
    }

    public int[] getImageAsSingleArray() {
        return BitImage.getImageAsSingleArray(this);
    }

    public static int[] getImageAsSingleArray(BitImage img) {
        int[] ret = new int[img.getWidth() * img.getHeight()];
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                ret[x + y * img.getWidth()] = img.get(x, y).getRGB();
            }
        }
        return ret;
    }

    public boolean supportsMChat() {
        int y;
        int x;
        boolean headcomp = false;
        block0: for (x = 32; x < 64; ++x) {
            for (y = 8; y < 16; ++y) {
                if (this.get(x, y).getAlpha() != 0) continue;
                headcomp = true;
                continue block0;
            }
        }
        if (!headcomp) {
            block2: for (x = 40; x < 56; ++x) {
                for (y = 0; y < 8; ++y) {
                    if (this.get(x, y).getAlpha() != 0) continue;
                    headcomp = true;
                    continue block2;
                }
            }
        }
        return headcomp;
    }

    public void removeMCHat() {
        int y;
        int x;
        Color inv = new Color(0, 0, 0, 0);
        for (x = 32; x < 64; ++x) {
            for (y = 8; y < 16; ++y) {
                this.set(x, y, inv);
            }
        }
        for (x = 40; x < 56; ++x) {
            for (y = 0; y < 8; ++y) {
                this.set(x, y, inv);
            }
        }
    }

    public boolean isInsideMCHat(int x, int y) {
        return this.isInside(x, y) && (x >= 32 && y >= 8 && y < 16 || x >= 40 && x < 56 && y < 8);
    }

    public void removeMCAlpha() {
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 32; ++y) {
                Color c;
                if (this.isInsideMCHat(x, y) || (c = this.get(x, y)).getAlpha() >= 255) continue;
                this.set(x, y, Color.BLACK);
            }
        }
    }

    public int getWidth() {
        return this.WIDTH;
    }

    public int getHeight() {
        return this.HEIGTH;
    }
}

