/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.frames.partpicker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.classes.BitImage;
import swedtech.mcskinedit.classes.Location;
import swedtech.mcskinedit.classes.PNGFilenameFilter;
import swedtech.mcskinedit.classes.PickerListItem;
import swedtech.mcskinedit.frames.ErrorScreen;
import swedtech.mcskinedit.frames.ProgramWindow;
import swedtech.mcskinedit.icons.ProgramIcon;
import swedtech.mcskinedit.panels.PreviewPane;

public class PartsPicker
implements ActionListener,
WindowListener,
ChangeListener {
    private final JDialog frame;
    private final JPanel main;
    private final JList used;
    private final JList avaible;
    private final DefaultListModel usedData;
    private final DefaultListModel avaibleData;
    private final PreviewPane prew;
    private final BitImage img;
    private final PreviewPane itemPrew;
    private final JCheckBox addBehindImage;

    private static ImageIcon getIcon(String name) {
        return new ImageIcon(PartsPicker.class.getResource(name + ".png"));
    }

    private PartsPicker(JFrame owner, BitImage img) {
        this.img = img;
        this.frame = new JDialog(owner, "SkinEdit PartsPicker", true);
        ProgramWindow.instance.pane.setMessage("PartPicker is loading...");
        if (Launcher.JAVAVERSION >= 6) {
            new Thread(new Runnable(){

                public void run() {
                    PartsPicker.this.frame.setIconImages(ProgramIcon.getProgramIcons());
                }
            }).start();
        }
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this);
        this.main = new JPanel(new BorderLayout());
        this.usedData = new DefaultListModel();
        this.used = new JList(this.usedData);
        this.avaibleData = this.getAvaible();
        this.avaible = new JList(this.avaibleData);
        this.prew = new PreviewPane();
        JPanel buttonContainer = new JPanel(new GridLayout(0, 1, 2, 4));
        JButton add = new JButton(PartsPicker.getIcon("Add"));
        add.addActionListener(this);
        add.setActionCommand("add");
        buttonContainer.add(add);
        JButton remove = new JButton(PartsPicker.getIcon("Remove"));
        remove.addActionListener(this);
        remove.setActionCommand("remove");
        buttonContainer.add(remove);
        JButton up = new JButton(PartsPicker.getIcon("Up"));
        up.addActionListener(this);
        up.setActionCommand("up");
        buttonContainer.add(up);
        JButton down = new JButton(PartsPicker.getIcon("Down"));
        down.addActionListener(this);
        down.setActionCommand("down");
        buttonContainer.add(down);
        JButton ok = new JButton(PartsPicker.getIcon("Yes"));
        ok.addActionListener(this);
        ok.setActionCommand("ok");
        buttonContainer.add(ok);
        JScrollPane sUsed = new JScrollPane(this.used);
        JScrollPane sAvaible = new JScrollPane(this.avaible);
        sUsed.setPreferredSize(sAvaible.getPreferredSize());
        this.main.add((Component)sUsed, "West");
        this.main.add((Component)buttonContainer, "Center");
        this.main.add((Component)sAvaible, "East");
        JPanel settings = new JPanel(new BorderLayout());
        this.itemPrew = new PreviewPane(1);
        this.addBehindImage = new JCheckBox("Add behind image", false);
        this.addBehindImage.setToolTipText("Whether the parts should be added behind the current image instead of on top of them");
        settings.add((Component)this.itemPrew, "North");
        settings.add((Component)this.addBehindImage, "Center");
        this.addBehindImage.addChangeListener(this);
        this.avaible.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (PartsPicker.this.avaible.getSelectedIndex() > -1) {
                    PartsPicker.this.itemPrew.setImage(((PickerListItem)PartsPicker.this.avaibleData.get(PartsPicker.this.avaible.getSelectedIndex())).getBitImage());
                }
            }
        });
        JPanel extra = new JPanel(new BorderLayout());
        extra.add((Component)this.prew, "West");
        extra.add((Component)this.main, "Center");
        extra.add((Component)settings, "East");
        this.frame.add(extra);
        this.frame.setResizable(true);
        this.frame.pack();
        this.frame.setLocationRelativeTo(owner);
        ProgramWindow.instance.pane.setMessage("Close PartPicker to continue");
        this.prew.start();
        this.itemPrew.start();
        this.updatePreview();
        this.frame.setVisible(true);
    }

    private DefaultListModel getAvaible() {
        final DefaultListModel def = new DefaultListModel();
        final File folder = new File(Location.skinEdit() + File.separator + "parts" + File.separator);
        if (!folder.isDirectory()) {
            return def;
        }
        new Thread(new Runnable(){

            public void run() {
                for (File f : folder.listFiles(new PNGFilenameFilter(false))) {
                    def.addElement(new PickerListItem(f));
                }
            }
        }).start();
        return def;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("add")) {
            int i = this.avaible.getSelectedIndex();
            if (i < 0) {
                return;
            }
            this.usedData.add(0, this.avaibleData.remove(i));
            this.used.setSelectedIndex(this.usedData.size() - 1);
            if (i == this.avaibleData.size()) {
                --i;
            }
            this.avaible.setSelectedIndex(i);
        } else if (cmd.equals("remove")) {
            int i = this.used.getSelectedIndex();
            if (i < 0) {
                return;
            }
            this.avaibleData.addElement(this.usedData.remove(i));
            if (i == this.usedData.size()) {
                --i;
            }
            this.used.setSelectedIndex(i);
        } else if (cmd.equals("up")) {
            int i = this.used.getSelectedIndex();
            if (i < 1) {
                return;
            }
            this.usedData.add(i - 1, this.usedData.remove(i));
            this.used.setSelectedIndex(i - 1);
        } else if (cmd.equals("down")) {
            int i = this.used.getSelectedIndex();
            if (i >= this.usedData.getSize() - 1) {
                return;
            }
            this.usedData.add(i + 1, this.usedData.remove(i));
            this.used.setSelectedIndex(i + 1);
        } else if (cmd.equals("close")) {
            if (JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to close the window\n\nAll your added parts will be lost", "Confirm", 0, 3) == 0) {
                this.usedData.clear();
                this.dispose();
            }
        } else if (cmd.equals("ok")) {
            this.dispose();
        } else {
            ErrorScreen.addError("Previewer: Unknown actioncommand " + cmd);
        }
        this.updatePreview();
    }

    private void dispose() {
        System.out.println("STOPPED");
        this.prew.stop();
        this.itemPrew.stop();
        this.frame.dispose();
        ProgramWindow.instance.pane.removeMessage();
    }

    private BitImage getAllImages() {
        BitImage total = new BitImage(this.img.getWidth(), this.img.getHeight());
        for (int i = this.usedData.size() - 1; i >= 0; --i) {
            total.append(((PickerListItem)this.usedData.get(i)).getBitImage());
        }
        return total;
    }

    private void updatePreview() {
        if (this.addBehindImage.isSelected()) {
            BitImage total = new BitImage(this.getAllImages());
            total.append(this.img);
            this.prew.setImage(total);
        } else {
            BitImage total = new BitImage(this.img);
            total.append(this.getAllImages());
            this.prew.setImage(total);
        }
    }

    public static void show(JFrame parent, BitImage bg) {
        PartsPicker p = new PartsPicker(parent, bg);
        if (p.addBehindImage.isSelected()) {
            BitImage i = p.getAllImages();
            i.append(bg);
            ProgramWindow.instance.image.setImage(i);
        } else {
            bg.append(p.getAllImages());
            ProgramWindow.instance.image.setImage(bg);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.actionPerformed(new ActionEvent(this, 1, "close"));
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        this.updatePreview();
    }
}

