/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.tools;

import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import swedtech.mcskinedit.frames.ProgramWindow;
import swedtech.mcskinedit.icons.ProgramIcon;
import swedtech.mcskinedit.tools.Tool;

public class ColorPickTool
implements Tool {
    ProgramWindow pw = ProgramWindow.instance;

    public JComponent getSettings() {
        return new JLabel(this.getName());
    }

    public String getName() {
        return "Color picker";
    }

    public Icon getIcon() {
        return ProgramIcon.getToolIcon("picker");
    }

    public void doPrimary(Point p) {
        p = this.toLocal(p);
        this.pw.color.setMain(this.pw.image.getImage().get(p.x, p.y));
    }

    public void doSecondary(Point p) {
        p = this.toLocal(p);
        this.pw.color.setAlt(this.pw.image.getImage().get(p.x, p.y));
    }

    private Point toLocal(Point p) {
        int scale = this.pw.editarea.getScale();
        return new Point(p.x / scale, p.y / scale);
    }

    public boolean allowDrag() {
        return true;
    }

    public int getSize() {
        return 1;
    }
}

