/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.tools;

import java.awt.Color;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import swedtech.mcskinedit.frames.ProgramWindow;
import swedtech.mcskinedit.icons.ProgramIcon;
import swedtech.mcskinedit.tools.Tool;

public class FloodTool
implements Tool {
    public JComponent getSettings() {
        return new JLabel(this.getName());
    }

    public String getName() {
        return "Flood";
    }

    public Icon getIcon() {
        return ProgramIcon.getToolIcon("bucket");
    }

    public void doPrimary(Point p) {
        this.process(p, ProgramWindow.instance.color.getMain());
    }

    public void doSecondary(Point p) {
        this.process(p, ProgramWindow.instance.color.getAlt());
    }

    public void process(Point point, Color c) {
        int scale = ProgramWindow.instance.editarea.getScale();
        Point p = new Point(point.x / scale, point.y / scale);
        ProgramWindow.instance.image.getImage().floodFill(p.x, p.y, c);
    }

    public boolean allowDrag() {
        return false;
    }

    public int getSize() {
        return 1;
    }
}

