/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.tools;

import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.icons.ProgramIcon;
import swedtech.mcskinedit.tools.MToolButton;
import swedtech.mcskinedit.tools.Tool;
import swedtech.mcskinedit.tools.ToolHandler;

public class MultiTool
implements Tool {
    JPanel settings = new JPanel(new GridLayout(0, 2));
    Tool primary = ToolHandler.getTool(Settings.getInstance().getProperty("multitoolprimaryname", "pen"));
    Tool secondary = ToolHandler.getTool(Settings.getInstance().getProperty("multitoolsecondaryname", "eraser"));
    boolean isPrimarySecondary = Settings.getInstance().getBoolean("multitoolprimissecondary", true);
    boolean isSecondarySecondary = Settings.getInstance().getBoolean("multitoolsecissecondary", true);
    JLabel primLabel;
    JLabel secLabel;

    public MultiTool() {
        MToolButton button;
        this.settings.add(new JLabel("Primary action"));
        this.primLabel = new JLabel(this.primary.getName(), this.primary.getIcon(), 2);
        this.settings.add(this.primLabel);
        ActionListener primListen = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("primary")) {
                    MultiTool.this.primary = ((MToolButton)e.getSource()).getTool();
                    MultiTool.this.primLabel.setIcon(MultiTool.this.primary.getIcon());
                    MultiTool.this.primLabel.setText(MultiTool.this.primary.getName());
                    Settings.getInstance().setProperty("multitoolprimaryname", MultiTool.this.primary.getName());
                } else {
                    MultiTool.this.secondary = ((MToolButton)e.getSource()).getTool();
                    MultiTool.this.secLabel.setIcon(MultiTool.this.secondary.getIcon());
                    MultiTool.this.secLabel.setText(MultiTool.this.secondary.getName());
                    Settings.getInstance().setProperty("multitoolsecondaryname", MultiTool.this.secondary.getName());
                }
            }
        };
        final JCheckBox chx1 = new JCheckBox("Run secondary", !this.isPrimarySecondary);
        final JCheckBox chx2 = new JCheckBox("Run secondary", !this.isSecondarySecondary);
        ChangeListener chListen = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Launcher.dbg("** State Changed in tool settings!");
                if (e.getSource() == chx1) {
                    MultiTool.this.isPrimarySecondary = chx1.isSelected();
                    Settings.getInstance().setProperty("multitoolprimissecondary", "" + MultiTool.this.isPrimarySecondary);
                } else {
                    MultiTool.this.isSecondarySecondary = chx2.isSelected();
                    Settings.getInstance().setProperty("multitoolsecissecondary", "" + MultiTool.this.isSecondarySecondary);
                }
            }
        };
        boolean addEmpty = false;
        for (Tool t : ToolHandler.getTools()) {
            button = new MToolButton(t);
            button.addActionListener(primListen);
            button.setActionCommand("primary");
            this.settings.add(button);
            addEmpty = !addEmpty;
        }
        Launcher.dbg("\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7 " + addEmpty);
        if (addEmpty) {
            this.settings.add(new JPanel());
        }
        chx1.addChangeListener(chListen);
        this.settings.add(chx1);
        this.settings.add(new JPanel());
        this.settings.add(new JLabel("Secondary action"));
        this.secLabel = new JLabel(this.secondary.getName(), this.secondary.getIcon(), 2);
        this.settings.add(this.secLabel);
        addEmpty = false;
        for (Tool t : ToolHandler.getTools()) {
            button = new MToolButton(t);
            button.addActionListener(primListen);
            button.setActionCommand("secondary");
            this.settings.add(button);
            addEmpty = !addEmpty;
        }
        Launcher.dbg("@@@@@" + addEmpty);
        if (addEmpty) {
            this.settings.add(new JPanel());
        }
        chx2.addChangeListener(chListen);
        this.settings.add(chx2);
        this.settings.add(new JPanel());
    }

    public JComponent getSettings() {
        return this.settings;
    }

    public String getName() {
        return "Multitool";
    }

    public Icon getIcon() {
        return ProgramIcon.getToolIcon("multi");
    }

    public void doPrimary(Point p) {
        if (!this.isPrimarySecondary) {
            this.primary.doPrimary(p);
        } else {
            this.primary.doSecondary(p);
        }
    }

    public void doSecondary(Point p) {
        if (!this.isSecondarySecondary) {
            this.secondary.doPrimary(p);
        } else {
            this.secondary.doSecondary(p);
        }
    }

    public boolean allowDrag() {
        return true;
    }

    public int getSize() {
        return 1;
    }
}

