/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop;

import com.Acrobot.iConomyChestShop.Chests.MinecraftChest;
import com.Acrobot.iConomyChestShop.ConfigManager;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaChest;
import com.Acrobot.iConomyChestShop.SignManager;
import info.somethingodd.bukkit.OddItem.OddItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Basic {
    public static OddItem OI = null;

    public static boolean isInt(String i) {
        try {
            Integer.parseInt(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloat(String i) {
        try {
            Float.parseFloat(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean cfgExists() {
        return new File("plugins/iConomyChestShop/config.yml").exists();
    }

    public static boolean goodCfg() {
        String posString = ConfigManager.getString("position").toUpperCase();
        try {
            BlockFace.valueOf((String)posString);
            return true;
        }
        catch (Exception iae) {
            return posString.equals("ANY");
        }
    }

    public static Material getMat(String name) {
        if (Basic.isInt(name)) {
            return Basic.getMat(Integer.parseInt(name));
        }
        return Material.getMaterial((int)Basic.returnID(name));
    }

    public static Material getMat(int id) {
        return Material.getMaterial((int)id);
    }

    public static int returnID(String name) {
        Material[] mat = Material.values();
        int temp = 9999;
        Material tmp = null;
        Material[] materialArray = mat;
        int n = mat.length;
        int n2 = 0;
        while (n2 < n) {
            Material m = materialArray[n2];
            if (m.name().toLowerCase().replaceAll("_", "").startsWith(name.toLowerCase().replaceAll("_", "").replaceAll(" ", "")) && m.name().length() < temp) {
                tmp = m;
                temp = m.name().length();
            }
            ++n2;
        }
        if (tmp != null) {
            return tmp.getId();
        }
        return -1;
    }

    public static ItemStack getItemStack(String name) {
        int dataPosition = name.indexOf(59);
        dataPosition = dataPosition != -1 ? dataPosition : -1;
        int dataValue = Basic.isInt(name.substring(dataPosition + 1)) ? Integer.parseInt(name.substring(dataPosition + 1)) : 0;
        dataValue = dataValue > 30 || dataValue < 0 ? 0 : dataValue;
        Material mat = dataPosition != -1 ? Basic.getMat(name.substring(0, dataPosition)) : Basic.getMat(name);
        if (OI != null) {
            try {
                return OI.getItemStack(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mat != null && mat != Material.AIR) {
            return new ItemStack(mat, 0, (short)dataValue);
        }
        return null;
    }

    public static String returnAlias(String name) {
        if (OI == null) {
            return null;
        }
        Set aliases = OI.getAliases(name);
        Iterator iter = aliases.iterator();
        String alias = null;
        if (iter.hasNext()) {
            alias = (String)iter.next();
        }
        return alias;
    }

    public static String colorChat(String msg) {
        String langChar = Character.toString('\u00a7');
        msg = msg.replaceAll("&", langChar);
        return msg;
    }

    public static boolean checkConfig(Player p) {
        if (!Basic.cfgExists()) {
            p.sendMessage("[iConomyChestShop] Config file doesn't exist!");
            p.sendMessage("[iConomyChestShop] Be sure to copy everything from .zip file to /plugins");
            return false;
        }
        if (!Basic.goodCfg()) {
            p.sendMessage("[iConomyChestShop] Incorrect config file!");
            return false;
        }
        return true;
    }

    public static String stripName(String name) {
        int length = name.length();
        if (length > 15) {
            length = 15;
        }
        return name.substring(0, length);
    }

    public static int getItemAmountFromInventory(Inventory inv, ItemStack is) {
        return Basic.getItemAmount(inv.getContents(), is);
    }

    public static int getItemAmount(ItemStack[] items, ItemStack is) {
        int id = is.getTypeId();
        boolean checkDurability = true;
        if (ConfigManager.getBoolean("allowUsedItemsToBeSold") && id >= 256 && id <= 317) {
            checkDurability = false;
        }
        int count = 0;
        ItemStack[] itemStackArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack Item = itemStackArray[n2];
            if (!(Item == null || Item.getType() != is.getType() || Item.getDurability() != is.getDurability() && Item.getDurability() != -1 && checkDurability || Item.getAmount() <= 0)) {
                count += Item.getAmount();
            }
            ++n2;
        }
        return count;
    }

    public static void removeItemStackFromInventory(Inventory inv, ItemStack is, int left) {
        ItemStack[] Items = inv.getContents();
        boolean checkDurability = true;
        int id = is.getTypeId();
        if (ConfigManager.getBoolean("allowUsedItemsToBeSold") && id >= 256 && id <= 317) {
            checkDurability = false;
        }
        int i = 0;
        while (i < Items.length) {
            if (left <= 0) {
                return;
            }
            ItemStack curItem = Items[i];
            if (curItem != null) {
                if (!(curItem.getType() != is.getType() || curItem.getDurability() != is.getDurability() && curItem.getDurability() != -1 && checkDurability)) {
                    int toRemove = left;
                    left -= curItem.getAmount();
                    if (curItem.getAmount() > toRemove) {
                        curItem.setAmount(curItem.getAmount() - toRemove);
                    } else {
                        curItem = null;
                    }
                }
                if (curItem != null) {
                    if (curItem.getType() != Material.AIR) {
                        inv.setItem(i, curItem);
                    }
                } else {
                    inv.setItem(i, null);
                }
            }
            ++i;
        }
    }

    public static void addItemToInventory(MinecartManiaChest chest, ItemStack is, int left) {
        Basic.addItemToInventory(chest.getInventory(), is, left);
    }

    public static void addItemToInventory(Inventory inv, ItemStack is, int left) {
        int maxStackSize = is.getType().getMaxStackSize();
        if (left <= maxStackSize) {
            is.setAmount(left);
            inv.addItem(new ItemStack[]{is});
            return;
        }
        if (maxStackSize != 64) {
            Object[] iArray;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int i = 0;
            while ((double)i < Math.ceil(left / maxStackSize)) {
                if (left < maxStackSize) {
                    is.setAmount(left);
                    items.add(is);
                    return;
                }
                is.setAmount(maxStackSize);
                items.add(is);
                ++i;
            }
            Object[] objectArray = iArray = items.toArray();
            int n = iArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                inv.addItem(new ItemStack[]{(ItemStack)o});
                ++n2;
            }
        } else {
            inv.addItem(new ItemStack[]{is});
        }
    }

    public static MinecraftChest findChest(Block block) {
        if (!ConfigManager.getString("position").toUpperCase().equals("ANY")) {
            Block faceBlock = block.getFace(BlockFace.valueOf((String)ConfigManager.getString("position").toUpperCase()), ConfigManager.getInt("distance"));
            return faceBlock != null && faceBlock.getType() == Material.CHEST ? new MinecraftChest((Chest)faceBlock.getState()) : null;
        }
        BlockFace[] blockFaceArray = BlockFace.values();
        int n = blockFaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace bf = blockFaceArray[n2];
            if (block.getFace(bf) != null && block.getFace(bf).getType() == Material.CHEST) {
                return new MinecraftChest((Chest)block.getFace(bf).getState());
            }
            ++n2;
        }
        return null;
    }

    public static CraftSign findSign(Block block) {
        if (!ConfigManager.getString("position").toUpperCase().equals("ANY")) {
            BlockFace face = BlockFace.valueOf((String)ConfigManager.getString("position").toUpperCase());
            int distance = ConfigManager.getInt("distance");
            Block faceBlock = block.getRelative(face.getModX() * -distance, face.getModY() * -distance, face.getModZ() * -distance);
            return faceBlock != null && faceBlock.getType() == Material.SIGN || faceBlock.getType() == Material.SIGN_POST || faceBlock.getType() == Material.WALL_SIGN && SignManager.mySign((Sign)((CraftSign)faceBlock.getState())) ? (CraftSign)faceBlock.getState() : null;
        }
        BlockFace[] blockFaceArray = BlockFace.values();
        int n = blockFaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CraftSign sign;
            BlockFace bf = blockFaceArray[n2];
            Block faceBlock = block.getFace(bf);
            if ((faceBlock != null && faceBlock.getType() == Material.SIGN || faceBlock.getType() == Material.SIGN_POST || faceBlock.getType() == Material.WALL_SIGN) && SignManager.mySign((Sign)(sign = (CraftSign)faceBlock.getState()))) {
                return sign;
            }
            ++n2;
        }
        return null;
    }

    public static boolean checkFreeSpace(MinecartManiaChest chest, ItemStack is, int left) {
        Inventory inv = chest.getInventory();
        return Basic.checkFreeSpace(inv, is, left);
    }

    public static boolean checkFreeSpace(Inventory inv, ItemStack is, int left) {
        return Basic.checkFreeSpace(inv.getContents(), is, left);
    }

    public static boolean checkFreeSpace(ItemStack[] contents, ItemStack is, int left) {
        Material type = is.getType();
        short durability = is.getDurability();
        int maxStack = is.getType().getMaxStackSize();
        ItemStack[] itemStackArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            int amount;
            ItemStack curitem = itemStackArray[n2];
            if (left <= 0) {
                return true;
            }
            if (curitem == null) {
                left -= maxStack;
            } else if (curitem.getType() == type && (curitem.getDurability() == durability || curitem.getDurability() == -1) && (amount = curitem.getAmount()) < maxStack) {
                left -= maxStack - amount;
            }
            ++n2;
        }
        return left <= 0;
    }

    public static void cancelEventAndDropSign(SignChangeEvent event) {
        event.setCancelled(true);
        Block block = event.getBlock();
        block.setType(Material.AIR);
        block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.SIGN, 1));
    }
}

