/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop.Chests;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.Chests.ChestObject;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaChest;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaDoubleChest;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public class MinecraftChest
implements ChestObject {
    public final MinecartManiaChest main;
    public final MinecartManiaChest extended;

    public MinecraftChest(Chest main) {
        this.main = new MinecartManiaChest(main);
        this.extended = this.main.getNeighborChest();
    }

    public boolean exists() {
        return this.main != null;
    }

    private MinecartManiaDoubleChest doubleChest() {
        return new MinecartManiaDoubleChest(this.main, this.extended);
    }

    @Override
    public ItemStack[] getContents() {
        if (this.extended != null) {
            return this.doubleChest().getContents();
        }
        return this.main.getContents();
    }

    @Override
    public void setSlot(int slot, ItemStack item) {
        if (this.extended != null) {
            this.doubleChest().setItem(slot, item);
            return;
        }
        this.main.setItem(slot, item);
    }

    @Override
    public void clearSlot(int slot) {
        if (this.extended != null) {
            this.doubleChest().setItem(slot, null);
            return;
        }
        this.main.setItem(slot, null);
    }

    @Override
    public void addItem(ItemStack item, int amount) {
        if (this.extended != null) {
            this.doubleChest().addItem(new ItemStack(item.getType(), amount, item.getDurability()));
            return;
        }
        this.main.addItem(new ItemStack(item.getType(), amount, item.getDurability()));
    }

    @Override
    public void removeItem(ItemStack item, int amount) {
        if (this.extended != null) {
            this.doubleChest().removeItem(item.getTypeId(), amount, item.getDurability());
            return;
        }
        this.main.removeItem(item.getTypeId(), amount, item.getDurability());
    }

    @Override
    public int amount(ItemStack item) {
        if (this.extended != null) {
            return this.doubleChest().amount(item);
        }
        return this.main.amount(item);
    }

    @Override
    public boolean hasEnough(ItemStack item, int amount) {
        return this.amount(item) >= amount;
    }

    @Override
    public boolean fits(ItemStack item, int amount) {
        if (this.extended != null) {
            return Basic.checkFreeSpace(this.main, item, amount) || Basic.checkFreeSpace(this.extended, item, amount);
        }
        return Basic.checkFreeSpace(this.main, item, amount);
    }

    @Override
    public int getSize() {
        return this.extended != null ? 2 * this.main.size() : this.main.size();
    }
}

