/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.EconomyManager;
import com.Acrobot.iConomyChestShop.iConomyChestShop;
import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.util.config.Configuration;

public class ConfigManager {
    public static final Configuration ChestShopConfig = new Configuration(new File("plugins/iConomyChestShop/config.yml"));

    public static boolean getBoolean(String node) {
        return ChestShopConfig.getBoolean(node, false);
    }

    public static String getString(String node) {
        return ChestShopConfig.getString(node);
    }

    public static int getInt(String node) {
        return ChestShopConfig.getInt(node, 0);
    }

    public static double getDouble(String node) {
        return ChestShopConfig.getDouble(node, -1.0);
    }

    public static String getLanguage(String node) {
        String prefix = ChestShopConfig.getNode("lang").getString("prefix", "[Shop]");
        String str = String.valueOf(prefix) + ChestShopConfig.getNode("lang").getString(node, "Error - no translation for " + node);
        str = Basic.colorChat(str);
        return str;
    }

    public static void load() {
        ChestShopConfig.load();
    }

    public static void buyingString(int amount, String item, String owner, Player player, float cost) {
        String str = ConfigManager.getLanguage("You_bought_items");
        str = str.replace("<amount>", String.valueOf(amount));
        str = str.replace("<item>", item);
        str = str.replace("<owner>", owner.replace("[", ""));
        str = str.replace("<cost>", ConfigManager.formattedBalance(cost));
        player.sendMessage(str);
        ConfigManager.moneyLeft(player);
        ConfigManager.buyingStringForShopOwner(amount, item, owner, player, cost);
        if (ConfigManager.separateMessages()) {
            player.sendMessage(ConfigManager.getSeparatingLine());
        }
    }

    public static void sellingString(int amount, String item, String owner, Player player, float cost) {
        String str = ConfigManager.getLanguage("You_sold_items");
        str = str.replace("<amount>", String.valueOf(amount));
        str = str.replace("<item>", item);
        str = str.replace("<owner>", owner.replace("[", ""));
        str = str.replace("<cost>", ConfigManager.formattedBalance(cost));
        player.sendMessage(str);
        ConfigManager.sellingStringForShopOwner(amount, item, owner, player, cost);
        ConfigManager.moneyLeft(player);
        if (ConfigManager.separateMessages()) {
            player.sendMessage(ConfigManager.getSeparatingLine());
        }
    }

    public static void buyingStringForShopOwner(int amount, String item, String owner, Player player, float cost) {
        String str = ConfigManager.getLanguage("Somebody_bought_items_from_your_shop");
        str = str.replace("<amount>", String.valueOf(amount));
        str = str.replace("<item>", item);
        str = str.replace("<buyer>", player.getName());
        str = str.replace("<cost>", ConfigManager.formattedBalance(cost));
        Player ownerPlayer = iConomyChestShop.getBukkitServer().getPlayer(owner);
        if (ownerPlayer == null) {
            return;
        }
        ownerPlayer.sendMessage(str);
        if (ConfigManager.separateMessages()) {
            ownerPlayer.sendMessage(ConfigManager.getSeparatingLine());
        }
    }

    public static void sellingStringForShopOwner(int amount, String item, String owner, Player player, float cost) {
        String str = ConfigManager.getLanguage("Somebody_sold_items_to_your_shop");
        str = str.replace("<amount>", String.valueOf(amount));
        str = str.replace("<item>", item);
        str = str.replace("<seller>", player.getName());
        str = str.replace("<cost>", ConfigManager.formattedBalance(cost));
        Player ownerPlayer = iConomyChestShop.getBukkitServer().getPlayer(owner);
        if (ownerPlayer == null) {
            return;
        }
        ownerPlayer.sendMessage(str);
        if (ConfigManager.separateMessages()) {
            ownerPlayer.sendMessage(ConfigManager.getSeparatingLine());
        }
    }

    public static String formattedBalance(double balance) {
        return EconomyManager.formatedBalance(balance);
    }

    public static void moneyLeft(Player player) {
        if (!ConfigManager.getBoolean("showMoneyAfterTransaction")) {
            return;
        }
        double balance = EconomyManager.balance(player.getName());
        String msg = ConfigManager.getLanguage("Your_balance");
        msg = msg.replace("<money>", ConfigManager.formattedBalance(balance));
        player.sendMessage(msg);
    }

    public static String getSeparatingLine() {
        return ChatColor.RED + "---------------------------------";
    }

    public static boolean separateMessages() {
        return ConfigManager.getBoolean("separatingLineAfterTransaction");
    }
}

