/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop.MinecartMania;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaChest;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaInventory;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MinecartManiaDoubleChest
implements MinecartManiaInventory {
    private final MinecartManiaChest chest1;
    private final MinecartManiaChest chest2;

    public MinecartManiaDoubleChest(MinecartManiaChest left, MinecartManiaChest right) {
        this.chest1 = left;
        this.chest2 = right;
    }

    public boolean equals(Location loc) {
        return loc.equals((Object)this.chest1.getLocation()) || loc.equals((Object)this.chest2.getLocation());
    }

    @Override
    public boolean canAddItem(ItemStack item) {
        return this.chest1.canAddItem(item) || this.chest2.canAddItem(item);
    }

    @Override
    public boolean addItem(ItemStack item) {
        return this.chest1.addItem(item);
    }

    @Override
    public boolean addItem(int type) {
        return this.chest1.addItem(type);
    }

    @Override
    public boolean addItem(int type, int amount) {
        return this.chest1.addItem(type, amount);
    }

    @Override
    public boolean canRemoveItem(int type, int amount, short durability) {
        return this.chest1.canRemoveItem(type, amount, durability) || this.chest2.canRemoveItem(type, amount, durability);
    }

    @Override
    public boolean removeItem(int type, int amount, short durability) {
        return this.chest1.removeItem(type, amount, durability);
    }

    @Override
    public boolean removeItem(int type, int amount) {
        return this.chest1.removeItem(type, amount);
    }

    @Override
    public boolean removeItem(int type) {
        return this.chest1.removeItem(type);
    }

    @Override
    public ItemStack getItem(int slot) {
        if (slot < this.chest1.size()) {
            return this.chest1.getItem(slot);
        }
        return this.chest2.getItem(slot - this.chest1.size());
    }

    @Override
    public void setItem(int slot, ItemStack item) {
        if (slot < this.chest1.size()) {
            this.chest1.setItem(slot, item);
        } else {
            this.chest2.setItem(slot - this.chest1.size(), item);
        }
    }

    @Override
    public int firstEmpty() {
        if (this.chest1.firstEmpty() != -1) {
            return this.chest1.firstEmpty();
        }
        if (this.chest2.firstEmpty() != -1) {
            return this.chest2.firstEmpty() + this.chest1.size();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.chest1.size() + this.chest2.size();
    }

    @Override
    public ItemStack[] getContents() {
        ItemStack[] contents = new ItemStack[this.size()];
        int i = 0;
        while (i < this.chest1.size()) {
            contents[i] = this.chest1.getItem(i);
            ++i;
        }
        i = 0;
        while (i < this.chest2.size()) {
            contents[i + this.chest1.size()] = this.chest2.getItem(i);
            ++i;
        }
        return contents;
    }

    @Override
    public void setContents(ItemStack[] contents) {
        ItemStack[] side1 = new ItemStack[this.chest1.size()];
        ItemStack[] side2 = new ItemStack[this.chest2.size()];
        int i = 0;
        while (i < contents.length) {
            if (i < side1.length) {
                side1[i] = contents[i];
            } else {
                side2[i - side1.length] = contents[i];
            }
            ++i;
        }
        this.chest1.setContents(side1);
        this.chest2.setContents(side2);
    }

    @Override
    public int first(Material material) {
        return this.first(material.getId(), (short)-1);
    }

    @Override
    public int first(ItemStack item) {
        return this.first(item.getTypeId(), item.getDurability() > 0 ? (short)item.getDurability() : (short)-1);
    }

    @Override
    public int first(int type) {
        return this.first(type, (short)-1);
    }

    public int first(int type, short durability) {
        if (this.chest1.first(type, durability) != -1) {
            return this.chest1.first(type);
        }
        if (this.chest2.first(type, durability) != -1) {
            return this.chest2.first(type) + this.chest1.size();
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        ItemStack[] itemStackArray = this.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (i != null && i.getType() != Material.AIR) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean contains(Material material) {
        return this.chest1.contains(material) || this.chest2.contains(material);
    }

    @Override
    public boolean contains(ItemStack item) {
        return this.chest1.contains(item) || this.chest2.contains(item);
    }

    @Override
    public boolean contains(int type) {
        return this.chest1.contains(type) || this.chest2.contains(type);
    }

    @Override
    public boolean contains(int type, short durability) {
        return this.chest1.contains(type, durability) || this.chest2.contains(type, durability);
    }

    @Override
    public int amount(ItemStack item) {
        return Basic.getItemAmountFromInventory(this.chest1.getInventory(), item) + Basic.getItemAmountFromInventory(this.chest2.getInventory(), item);
    }
}

