/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.iConomyChestShop.MinecartMania;

import com.Acrobot.iConomyChestShop.Basic;
import com.Acrobot.iConomyChestShop.MinecartMania.MinecartManiaInventory;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class MinecartManiaSingleContainer
implements MinecartManiaInventory {
    private Inventory inventory;

    public MinecartManiaSingleContainer(Inventory i) {
        this.inventory = i;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void updateInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public boolean canAddItem(ItemStack item) {
        return item.getTypeId() != Material.AIR.getId();
    }

    @Override
    public boolean addItem(ItemStack item) {
        if (!this.canAddItem(item)) {
            return false;
        }
        if (item == null) {
            return true;
        }
        ItemStack[] backup = (ItemStack[])this.getContents().clone();
        int max = item.getType().getMaxStackSize();
        int i = 0;
        while (i < this.size()) {
            if (this.getItem(i) != null && this.getItem(i).getTypeId() == item.getTypeId() && this.getItem(i).getDurability() == item.getDurability()) {
                if (this.getItem(i).getAmount() + item.getAmount() <= max) {
                    this.setItem(i, new ItemStack(item.getTypeId(), this.getItem(i).getAmount() + item.getAmount(), item.getDurability()));
                    return true;
                }
                int diff = this.getItem(i).getAmount() + item.getAmount() - max;
                this.setItem(i, new ItemStack(item.getTypeId(), max, item.getDurability()));
                item = new ItemStack(item.getTypeId(), diff, item.getDurability());
            }
            ++i;
        }
        int emptySlot = this.firstEmpty();
        if (emptySlot > -1) {
            this.setItem(emptySlot, item);
            return true;
        }
        this.setContents(backup);
        return false;
    }

    @Override
    public boolean addItem(int type, int amount) {
        return this.addItem(new ItemStack(type, amount));
    }

    @Override
    public boolean addItem(int type) {
        return this.addItem(new ItemStack(type, 1));
    }

    @Override
    public boolean canRemoveItem(int type, int amount, short durability) {
        return true;
    }

    @Override
    public boolean removeItem(int type, int amount, short durability) {
        if (!this.canRemoveItem(type, amount, durability)) {
            return false;
        }
        ItemStack[] backup = (ItemStack[])this.getContents().clone();
        int i = 0;
        while (i < this.size()) {
            if (this.getItem(i) != null && this.getItem(i).getTypeId() == type && (durability == -1 || this.getItem(i).getDurability() == durability)) {
                if (this.getItem(i).getAmount() - amount > 0) {
                    this.setItem(i, new ItemStack(type, this.getItem(i).getAmount() - amount, durability));
                    return true;
                }
                if (this.getItem(i).getAmount() - amount == 0) {
                    this.setItem(i, null);
                    return true;
                }
                amount -= this.inventory.getItem(i).getAmount();
                this.setItem(i, null);
            }
            ++i;
        }
        this.setContents(backup);
        return false;
    }

    @Override
    public boolean removeItem(int type, int amount) {
        return this.removeItem(type, amount, (short)-1);
    }

    @Override
    public boolean removeItem(int type) {
        return this.removeItem(type, 1);
    }

    @Override
    public ItemStack getItem(int slot) {
        ItemStack i = this.getInventory().getItem(slot);
        return i == null ? null : (i.getTypeId() == Material.AIR.getId() ? null : i);
    }

    @Override
    public void setItem(int slot, ItemStack item) {
        if (item == null) {
            this.getInventory().clear(slot);
        } else {
            this.getInventory().setItem(slot, item);
        }
    }

    @Override
    public int firstEmpty() {
        int i = 0;
        while (i < this.size()) {
            if (this.getItem(i) == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.getInventory().getSize();
    }

    @Override
    public ItemStack[] getContents() {
        return this.getInventory().getContents();
    }

    @Override
    public void setContents(ItemStack[] contents) {
        this.getInventory().setContents(contents);
    }

    @Override
    public int first(Material material) {
        return this.first(material.getId(), (short)-1);
    }

    @Override
    public int first(ItemStack item) {
        return this.first(item.getTypeId(), item.getDurability() > 0 ? (short)item.getDurability() : (short)-1);
    }

    @Override
    public int first(int type) {
        return this.first(type, (short)-1);
    }

    public int first(int type, short durability) {
        int i = 0;
        while (i < this.size()) {
            if (this.getItem(i) != null && this.getItem(i).getTypeId() == type && (durability == -1 || this.getItem(i).getDurability() == -1 || this.getItem(i).getDurability() == durability)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int amount(ItemStack item) {
        return Basic.getItemAmountFromInventory(this.getInventory(), item);
    }

    @Override
    public boolean contains(Material material) {
        return this.first(material) != -1;
    }

    @Override
    public boolean contains(ItemStack item) {
        return this.first(item) != -1;
    }

    @Override
    public boolean contains(int type) {
        return this.first(type) != -1;
    }

    @Override
    public boolean contains(int type, short durability) {
        return this.first(type, durability) != -1;
    }

    @Override
    public boolean isEmpty() {
        ItemStack[] itemStackArray = this.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (i != null && i.getType() != Material.AIR) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

