/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.Util;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.command.ColouredConsoleSender;
import org.bukkit.plugin.Plugin;

public class Backup
implements Runnable {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private CraftServer server = (CraftServer)Essentials.getStatic().getServer();
    private boolean running = false;
    private int taskId = -1;
    private boolean active = false;

    public Backup() {
        if (this.server.getOnlinePlayers().length > 0) {
            this.startTask();
        }
    }

    void onPlayerJoin() {
        this.startTask();
    }

    private void startTask() {
        if (!this.running) {
            long interval = Essentials.getStatic().getSettings().getBackupInterval() * 1200L;
            if (interval < 1200L) {
                return;
            }
            this.taskId = this.server.getScheduler().scheduleSyncRepeatingTask((Plugin)Essentials.getStatic(), (Runnable)this, interval, interval);
            this.running = true;
        }
    }

    public void run() {
        if (this.active) {
            return;
        }
        this.active = true;
        final String command = Essentials.getStatic().getSettings().getBackupCommand();
        if (command == null || "".equals(command)) {
            return;
        }
        logger.log(Level.INFO, Util.i18n("backupStarted"));
        ColouredConsoleSender cs = this.server.getServer().console;
        this.server.dispatchCommand((CommandSender)cs, "save-all");
        this.server.dispatchCommand((CommandSender)cs, "save-off");
        this.server.getScheduler().scheduleAsyncDelayedTask((Plugin)Essentials.getStatic(), new Runnable((CommandSender)cs){
            final /* synthetic */ CommandSender val$cs;
            {
                this.val$cs = commandSender;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                try {
                    Process child = Runtime.getRuntime().exec(command);
                    child.waitFor();
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                    Backup.this.server.getScheduler().scheduleSyncDelayedTask((Plugin)Essentials.getStatic(), new Runnable(){

                        public void run() {
                            Backup.this.server.dispatchCommand(val$cs, "save-on");
                            if (Backup.this.server.getOnlinePlayers().length == 0) {
                                Backup.this.running = false;
                                if (Backup.this.taskId != -1) {
                                    Backup.this.server.getScheduler().cancelTask(Backup.this.taskId);
                                }
                            }
                            Backup.this.active = false;
                            logger.log(Level.INFO, Util.i18n("backupFinished"));
                        }
                    });
                }
                catch (IOException ex2) {
                    logger.log(Level.SEVERE, null, ex2);
                    {
                        catch (Throwable throwable) {
                            Backup.this.server.getScheduler().scheduleSyncDelayedTask((Plugin)Essentials.getStatic(), new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                    }
                    Backup.this.server.getScheduler().scheduleSyncDelayedTask((Plugin)Essentials.getStatic(), new /* invalid duplicate definition of identical inner class */);
                }
                Backup.this.server.getScheduler().scheduleSyncDelayedTask((Plugin)Essentials.getStatic(), new /* invalid duplicate definition of identical inner class */);
            }
        });
    }
}

