/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageByProjectileEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityListener;
import org.bukkit.inventory.ItemStack;

public class EssentialsEntityListener
extends EntityListener {
    private final Essentials ess;

    public EssentialsEntityListener(Essentials parent) {
        this.ess = parent;
    }

    public void onEntityDamage(EntityDamageEvent event) {
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent edEvent = (EntityDamageByEntityEvent)event;
            Entity eAttack = edEvent.getDamager();
            Entity eDefend = edEvent.getEntity();
            if (eDefend instanceof Player && eAttack instanceof Player) {
                ItemStack is;
                User defender = this.ess.getUser(eDefend);
                User attacker = this.ess.getUser(eAttack);
                String command = attacker.getPowertool(is = attacker.getItemInHand());
                if (command != null && !command.isEmpty()) {
                    attacker.getServer().dispatchCommand((CommandSender)attacker, command.replaceAll("\\{player\\}", defender.getName()));
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if ((event instanceof EntityDamageEvent || event instanceof EntityDamageByBlockEvent || event instanceof EntityDamageByProjectileEvent) && event.getEntity() instanceof Player && this.ess.getUser(event.getEntity()).isGodModeEnabled()) {
            CraftPlayer player = (CraftPlayer)event.getEntity();
            player.getHandle().fireTicks = 0;
            player.setRemainingAir(player.getMaximumAir());
            event.setCancelled(true);
        }
    }

    public void onEntityCombust(EntityCombustEvent event) {
        if (event.getEntity() instanceof Player && this.ess.getUser(event.getEntity()).isGodModeEnabled()) {
            event.setCancelled(true);
        }
    }

    public void onEntityDeath(EntityDeathEvent event) {
        User user;
        if (event.getEntity() instanceof Player && (user = this.ess.getUser(event.getEntity())).isAuthorized("essentials.back.ondeath") && !this.ess.getSettings().isCommandDisabled("back")) {
            user.setLastLocation();
            user.sendMessage(Util.i18n("backAfterDeath"));
        }
    }
}

