/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import java.util.HashMap;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryWorkaround {
    public static int first(Inventory ci, ItemStack item, boolean forceDurability, boolean forceAmount) {
        return InventoryWorkaround.next(ci, item, 0, forceDurability, forceAmount);
    }

    public static int next(Inventory ci, ItemStack item, int start, boolean forceDurability, boolean forceAmount) {
        ItemStack[] inventory = ci.getContents();
        for (int i = start; i < inventory.length; ++i) {
            ItemStack cItem = inventory[i];
            if (cItem == null || item.getTypeId() != cItem.getTypeId() || forceAmount && item.getAmount() != cItem.getAmount() || forceDurability && cItem.getDurability() != item.getDurability()) continue;
            return i;
        }
        return -1;
    }

    public static HashMap<Integer, ItemStack> removeItem(Inventory ci, boolean forceDurability, ItemStack ... items) {
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (item == null) continue;
            int toDelete = item.getAmount();
            while (toDelete > 0) {
                int first = InventoryWorkaround.first(ci, item, forceDurability, false);
                if (first == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    continue block0;
                }
                ItemStack itemStack = ci.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    ci.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                ci.setItem(first, itemStack);
                toDelete = 0;
            }
        }
        return leftover;
    }

    public static boolean containsItem(Inventory ci, boolean forceDurability, ItemStack ... items) {
        int i;
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        ItemStack[] combined = new ItemStack[items.length];
        block0: for (i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            for (int j = 0; j < combined.length; ++j) {
                if (combined[j] == null) {
                    combined[j] = new ItemStack(items[i].getType(), items[i].getAmount(), items[i].getDurability());
                    continue block0;
                }
                if (combined[j].getTypeId() != items[i].getTypeId() || forceDurability && combined[j].getDurability() != items[i].getDurability()) continue;
                combined[j].setAmount(combined[j].getAmount() + items[i].getAmount());
                continue block0;
            }
        }
        block2: for (i = 0; i < combined.length; ++i) {
            ItemStack item = combined[i];
            if (item == null) continue;
            int mustHave = item.getAmount();
            int position = 0;
            while (mustHave > 0) {
                int slot = InventoryWorkaround.next(ci, item, position, forceDurability, false);
                if (slot == -1) {
                    leftover.put(i, item);
                    continue block2;
                }
                ItemStack itemStack = ci.getItem(slot);
                int amount = itemStack.getAmount();
                mustHave = amount <= mustHave ? (mustHave -= amount) : 0;
                position = slot + 1;
            }
        }
        return leftover.isEmpty();
    }
}

