/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.ItemDb;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import com.earth2me.essentials.commands.IEssentialsCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.entity.CreatureType;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings
implements IConf {
    private EssentialsConf config;
    private static final Logger logger = Logger.getLogger("Minecraft");

    public Settings(File dataFolder) {
        this.config = new EssentialsConf(new File(dataFolder, "config.yml"));
        this.config.setTemplateName("/config.yml");
        this.config.load();
    }

    public boolean getRespawnAtHome() {
        return this.config.getBoolean("respawn-at-home", false);
    }

    public boolean getBedSetsHome() {
        return this.config.getBoolean("bed-sethome", false);
    }

    public int getChatRadius() {
        return this.config.getInt("chat.radius", this.config.getInt("chat-radius", 0));
    }

    public double getTeleportDelay() {
        return this.config.getDouble("teleport-delay", 0.0);
    }

    public int getDefaultStackSize() {
        return this.config.getInt("default-stack-size", 64);
    }

    public String getCurrency() {
        return this.config.getString("currency-name", "Coin");
    }

    public String getCurrencyPlural() {
        return this.config.getString("currency-name-plural", "Coins");
    }

    public int getStartingBalance() {
        return this.config.getInt("starting-balance", 0);
    }

    public boolean getNetherPortalsEnabled() {
        return this.isNetherEnabled() && this.config.getBoolean("nether.portals-enabled", false);
    }

    public boolean isCommandDisabled(IEssentialsCommand cmd) {
        return this.isCommandDisabled(cmd.getName());
    }

    public boolean isCommandDisabled(String label) {
        for (String c : this.config.getStringList("disabled-commands", new ArrayList(0))) {
            if (!c.equalsIgnoreCase(label)) continue;
            return true;
        }
        return this.config.getBoolean("disable-" + label.toLowerCase(), false);
    }

    public boolean isCommandRestricted(IEssentialsCommand cmd) {
        return this.isCommandRestricted(cmd.getName());
    }

    public boolean isCommandRestricted(String label) {
        for (String c : this.config.getStringList("restricted-commands", new ArrayList(0))) {
            if (!c.equalsIgnoreCase(label)) continue;
            return true;
        }
        return this.config.getBoolean("restrict-" + label.toLowerCase(), false);
    }

    public boolean isCommandOverridden(String name) {
        ArrayList<String> defaultList = new ArrayList<String>(1);
        defaultList.add("god");
        for (String c : this.config.getStringList("overridden-commands", defaultList)) {
            if (!c.equalsIgnoreCase(name)) continue;
            return true;
        }
        return this.config.getBoolean("override-" + name.toLowerCase(), false);
    }

    public int getCommandCost(IEssentialsCommand cmd) {
        return this.getCommandCost(cmd.getName());
    }

    public int getCommandCost(String label) {
        int cost = this.config.getInt("command-costs." + label, 0);
        if (cost == 0) {
            cost = this.config.getInt("cost-" + label, 0);
        }
        return cost;
    }

    public String getCommandPrefix() {
        return this.config.getString("command-prefix", "");
    }

    public String getNicknamePrefix() {
        return this.config.getString("nickname-prefix", "");
    }

    public double getTeleportCooldown() {
        return this.config.getDouble("teleport-cooldown", 60.0);
    }

    public double getHealCooldown() {
        return this.config.getDouble("heal-cooldown", 60.0);
    }

    public Object getKit(String name) {
        Map kits = (Map)this.config.getProperty("kits");
        return kits.get(name.replace('.', '_').replace('/', '_'));
    }

    public ChatColor getOperatorColor() {
        String colorName = this.config.getString("ops-name-color", null);
        if (colorName == null) {
            return ChatColor.RED;
        }
        if ("none".equalsIgnoreCase(colorName) || colorName.isEmpty()) {
            return ChatColor.WHITE;
        }
        try {
            return ChatColor.valueOf((String)colorName.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ChatColor.getByCode((int)Integer.parseInt(colorName, 16));
        }
    }

    public boolean getReclaimSetting() {
        return this.config.getBoolean("reclaim-onlogout", true);
    }

    public String getNetherName() {
        return this.config.getString("nether.folder", "nether");
    }

    public boolean isNetherEnabled() {
        return this.config.getBoolean("nether.enabled", true);
    }

    public int getSpawnMobLimit() {
        return this.config.getInt("spawnmob-limit", 10);
    }

    public boolean showNonEssCommandsInHelp() {
        return this.config.getBoolean("non-ess-in-help", true);
    }

    public HashMap<String, Boolean> getEpSettings() {
        HashMap<String, Boolean> epSettings = new HashMap<String, Boolean>();
        epSettings.put("protect.protect.signs", this.config.getBoolean("protect.protect.signs", true));
        epSettings.put("protect.protect.rails", this.config.getBoolean("protect.protect.rails", true));
        epSettings.put("protect.protect.block-below", this.config.getBoolean("protect.protect.block-below", true));
        epSettings.put("protect.protect.prevent-block-on-rails", this.config.getBoolean("protect.protect.prevent-block-on-rails", false));
        return epSettings;
    }

    public HashMap<String, String> getEpDBSettings() {
        HashMap<String, String> epSettings = new HashMap<String, String>();
        epSettings.put("protect.datatype", this.config.getString("protect.datatype", "sqlite"));
        epSettings.put("protect.username", this.config.getString("protect.username", "root"));
        epSettings.put("protect.password", this.config.getString("protect.password", "root"));
        epSettings.put("protect.mysqlDb", this.config.getString("protect.mysqlDb", "jdbc:mysql://localhost:3306/minecraft"));
        return epSettings;
    }

    public ArrayList<Integer> getEpAlertOnPlacement() {
        ArrayList<Integer> epAlertPlace = new ArrayList<Integer>();
        for (String itemName : this.config.getString("protect.alert.on-placement", "").split(",")) {
            if ((itemName = itemName.trim()).isEmpty()) continue;
            try {
                ItemStack is = ItemDb.get(itemName);
                epAlertPlace.add(is.getTypeId());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, Util.format("unknownItemInList", itemName, "alert.on-placement"));
            }
        }
        return epAlertPlace;
    }

    public ArrayList<Integer> getEpAlertOnUse() {
        ArrayList<Integer> epAlertUse = new ArrayList<Integer>();
        for (String itemName : this.config.getString("protect.alert.on-use", "").split(",")) {
            if ((itemName = itemName.trim()).isEmpty()) continue;
            try {
                ItemStack is = ItemDb.get(itemName);
                epAlertUse.add(is.getTypeId());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, Util.format("unknownItemInList", itemName, "alert.on-use"));
            }
        }
        return epAlertUse;
    }

    public ArrayList<Integer> getEpAlertOnBreak() {
        ArrayList<Integer> epAlertPlace = new ArrayList<Integer>();
        for (String itemName : this.config.getString("protect.alert.on-break", "").split(",")) {
            if ((itemName = itemName.trim()).isEmpty()) continue;
            try {
                ItemStack is = ItemDb.get(itemName);
                epAlertPlace.add(is.getTypeId());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, Util.format("unknownItemInList", itemName, "alert.on-break"));
            }
        }
        return epAlertPlace;
    }

    public ArrayList<Integer> epBlackListPlacement() {
        ArrayList<Integer> epBlacklistPlacement = new ArrayList<Integer>();
        for (String itemName : this.config.getString("protect.blacklist.placement", "").split(",")) {
            if ((itemName = itemName.trim()).isEmpty()) continue;
            try {
                ItemStack is = ItemDb.get(itemName);
                epBlacklistPlacement.add(is.getTypeId());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, Util.format("unknownItemInList", itemName, "blacklist.placement"));
            }
        }
        return epBlacklistPlacement;
    }

    public ArrayList<Integer> epBlackListUsage() {
        ArrayList<Integer> epBlackListUsage = new ArrayList<Integer>();
        for (String itemName : this.config.getString("protect.blacklist.usage", "").split(",")) {
            if ((itemName = itemName.trim()).isEmpty()) continue;
            try {
                ItemStack is = ItemDb.get(itemName);
                epBlackListUsage.add(is.getTypeId());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, Util.format("unknownItemInList", itemName, "blacklist.usage"));
            }
        }
        return epBlackListUsage;
    }

    public HashMap<String, Boolean> getEpGuardSettings() {
        HashMap<String, Boolean> epSettings = new HashMap<String, Boolean>();
        epSettings.put("protect.prevent.lava-flow", this.config.getBoolean("protect.prevent.lava-flow", false));
        epSettings.put("protect.prevent.water-flow", this.config.getBoolean("protect.prevent.water-flow", false));
        epSettings.put("protect.prevent.water-bucket-flow", this.config.getBoolean("protect.prevent.water-bucket-flow", false));
        epSettings.put("protect.prevent.fire-spread", this.config.getBoolean("protect.prevent.fire-spread", false));
        epSettings.put("protect.prevent.flint-fire", this.config.getBoolean("protect.prevent.flint-fire", false));
        epSettings.put("protect.prevent.portal-creation", this.config.getBoolean("protect.prevent.portal-creation", false));
        epSettings.put("protect.prevent.lava-fire-spread", this.config.getBoolean("protect.prevent.lava-fire-spread", false));
        epSettings.put("protect.prevent.tnt-explosion", this.config.getBoolean("protect.prevent.tnt-explosion", false));
        epSettings.put("protect.prevent.creeper-explosion", this.config.getBoolean("protect.prevent.creeper-explosion", false));
        epSettings.put("protect.prevent.creeper-playerdamage", this.config.getBoolean("protect.prevent.creeper-playerdamage", false));
        epSettings.put("protect.prevent.creeper-blockdamage", this.config.getBoolean("protect.prevent.creeper-blockdamage", false));
        epSettings.put("protect.prevent.entitytarget", this.config.getBoolean("protect.prevent.entitytarget", false));
        for (CreatureType ct : CreatureType.values()) {
            String name = ct.toString().toLowerCase();
            epSettings.put("protect.prevent.spawn." + name, this.config.getBoolean("protect.prevent.spawn." + name, false));
        }
        epSettings.put("protect.prevent.lightning-fire-spread", this.config.getBoolean("protect.prevent.lightning-fire-spread", false));
        return epSettings;
    }

    public HashMap<String, Boolean> getEpPlayerSettings() {
        HashMap<String, Boolean> epPlayerSettings = new HashMap<String, Boolean>();
        epPlayerSettings.put("protect.disable.fall", this.config.getBoolean("protect.disable.fall", false));
        epPlayerSettings.put("protect.disable.pvp", this.config.getBoolean("protect.disable.pvp", false));
        epPlayerSettings.put("protect.disable.drown", this.config.getBoolean("protect.disable.drown", false));
        epPlayerSettings.put("protect.disable.suffocate", this.config.getBoolean("protect.disable.suffocate", false));
        epPlayerSettings.put("protect.disable.lavadmg", this.config.getBoolean("protect.disable.lavadmg", false));
        epPlayerSettings.put("protect.disable.projectiles", this.config.getBoolean("protect.disable.projectiles", false));
        epPlayerSettings.put("protect.disable.contactdmg", this.config.getBoolean("protect.disable.contactdmg", false));
        epPlayerSettings.put("protect.disable.firedmg", this.config.getBoolean("protect.disable.firedmg", false));
        epPlayerSettings.put("protect.disable.build", this.config.getBoolean("protect.disable.build", false));
        epPlayerSettings.put("protect.disable.lightning", this.config.getBoolean("protect.disable.lightning", false));
        epPlayerSettings.put("protect.disable.weather.lightning", this.config.getBoolean("protect.disable.weather.lightning", false));
        epPlayerSettings.put("protect.disable.weather.storm", this.config.getBoolean("protect.disable.weather.storm", false));
        epPlayerSettings.put("protect.disable.weather.thunder", this.config.getBoolean("protect.disable.weather.thunder", false));
        return epPlayerSettings;
    }

    public int getEpCreeperMaxHeight() {
        return this.config.getInt("protect.creeper.max-height", -1);
    }

    public boolean areSignsDisabled() {
        return this.config.getBoolean("signs-disabled", false);
    }

    public long getBackupInterval() {
        return this.config.getInt("backup.interval", 1440);
    }

    public String getBackupCommand() {
        return this.config.getString("backup.command", null);
    }

    public String getChatFormat(String group) {
        return this.config.getString("chat.group-formats." + (group == null ? "Default" : group), this.config.getString("chat.format", "&7[{GROUP}]&f {DISPLAYNAME}&7:&f {MESSAGE}"));
    }

    public boolean getGenerateExitPortals() {
        return this.config.getBoolean("nether.generate-exit-portals", true);
    }

    public boolean getAnnounceNewPlayers() {
        return !this.config.getString("newbies.announce-format", "-").isEmpty();
    }

    public String getAnnounceNewPlayerFormat(User user) {
        return this.format(this.config.getString("newbies.announce-format", "&dWelcome {DISPLAYNAME} to the server!"), user);
    }

    public String format(String format, User user) {
        return format.replace('&', '\u00a7').replace("\u00a7\u00a7", "&").replace("{PLAYER}", user.getDisplayName()).replace("{DISPLAYNAME}", user.getDisplayName()).replace("{GROUP}", user.getGroup()).replace("{USERNAME}", user.getName()).replace("{ADDRESS}", user.getAddress().toString());
    }

    public String getNewbieSpawn() {
        return this.config.getString("newbies.spawnpoint", "default");
    }

    public boolean getPerWarpPermission() {
        return this.config.getBoolean("per-warp-permission", false);
    }

    public boolean getSortListByGroups() {
        return this.config.getBoolean("sort-list-by-groups", true);
    }

    @Override
    public void reloadConfig() {
        this.config.load();
    }

    public ArrayList<Integer> itemSpawnBlacklist() {
        ArrayList<Integer> epItemSpwn = new ArrayList<Integer>();
        for (String itemName : this.config.getString("item-spawn-blacklist", "").split(",")) {
            if ((itemName = itemName.trim()).isEmpty()) continue;
            try {
                ItemStack is = ItemDb.get(itemName);
                epItemSpwn.add(is.getTypeId());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, Util.format("unknownItemInList", itemName, "item-spawn-blacklist"));
            }
        }
        return epItemSpwn;
    }

    public ArrayList<Integer> epBlockBreakingBlacklist() {
        ArrayList<Integer> epBreakList = new ArrayList<Integer>();
        for (String itemName : this.config.getString("protect.blacklist.break", "").split(",")) {
            if ((itemName = itemName.trim()).isEmpty()) continue;
            try {
                ItemStack is = ItemDb.get(itemName);
                epBreakList.add(is.getTypeId());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, Util.format("unknownItemInList", itemName, "blacklist.break"));
            }
        }
        return epBreakList;
    }

    public boolean spawnIfNoHome() {
        return this.config.getBoolean("spawn-if-no-home", false);
    }

    public boolean warnOnBuildDisallow() {
        return this.config.getBoolean("protect.disable.warn-on-build-disallow", false);
    }

    public boolean use1to1RatioInNether() {
        return this.config.getBoolean("nether.use-1to1-ratio", false);
    }

    public double getNetherRatio() {
        if (this.config.getBoolean("nether.use-1to1-ratio", false)) {
            return 1.0;
        }
        return this.config.getDouble("nether.ratio", 16.0);
    }

    public boolean isDebug() {
        return this.config.getBoolean("debug", false);
    }

    public boolean warnOnSmite() {
        return this.config.getBoolean("warn-on-smite", true);
    }

    public boolean permissionBasedItemSpawn() {
        return this.config.getBoolean("permission-based-item-spawn", false);
    }

    public String getLocale() {
        return this.config.getString("locale", "");
    }
}

