/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.Spawn;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Util;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class Teleport
implements Runnable {
    User user;
    private int teleTimer = -1;
    private long started;
    private long delay;
    private int health;
    private long initX;
    private long initY;
    private long initZ;
    private Target teleportTarget;
    private String chargeFor;
    private Essentials ess;

    private void initTimer(long delay, Target target, String chargeFor) {
        this.started = System.currentTimeMillis();
        this.delay = delay;
        this.health = this.user.getHealth();
        this.initX = Math.round(this.user.getLocation().getX() * 10000.0);
        this.initY = Math.round(this.user.getLocation().getY() * 10000.0);
        this.initZ = Math.round(this.user.getLocation().getZ() * 10000.0);
        this.teleportTarget = target;
        this.chargeFor = chargeFor;
    }

    public void run() {
        if (this.user == null || !this.user.isOnline() || this.user.getLocation() == null) {
            this.cancel();
            return;
        }
        if (Math.round(this.user.getLocation().getX() * 10000.0) != this.initX || Math.round(this.user.getLocation().getY() * 10000.0) != this.initY || Math.round(this.user.getLocation().getZ() * 10000.0) != this.initZ || this.user.getHealth() < this.health) {
            this.cancel(true);
            return;
        }
        this.health = this.user.getHealth();
        long now = System.currentTimeMillis();
        if (now > this.started + this.delay) {
            try {
                this.cooldown(false);
                this.user.sendMessage(Util.i18n("teleportationCommencing"));
                try {
                    this.now(this.teleportTarget);
                    if (this.chargeFor != null) {
                        this.user.charge(this.chargeFor);
                    }
                }
                catch (Throwable ex) {
                    this.user.sendMessage(Util.format("errorWithMessage", ex.getMessage()));
                }
                return;
            }
            catch (Exception ex) {
                this.user.sendMessage(Util.format("cooldownWithMessage", ex.getMessage()));
            }
        }
    }

    public Teleport(User user, Essentials ess) {
        this.user = user;
        this.ess = ess;
    }

    public void respawn(Spawn spawn, String chargeFor) throws Exception {
        this.teleport(new Target(spawn.getSpawn(this.user.getGroup())), chargeFor);
    }

    public void warp(String warp, String chargeFor) throws Exception {
        Location loc = Essentials.getWarps().getWarp(warp);
        this.teleport(new Target(loc), chargeFor);
        this.user.sendMessage(Util.format("warpingTo", warp));
    }

    public void cooldown(boolean check) throws Exception {
        GregorianCalendar now = new GregorianCalendar();
        if (this.user.getLastTeleportTimestamp() > 0L) {
            double cooldown = this.ess.getSettings().getTeleportCooldown();
            GregorianCalendar cooldownTime = new GregorianCalendar();
            cooldownTime.setTimeInMillis(this.user.getLastTeleportTimestamp());
            ((Calendar)cooldownTime).add(13, (int)cooldown);
            ((Calendar)cooldownTime).add(14, (int)(cooldown * 1000.0 % 1000.0));
            if (cooldownTime.after(now) && !this.user.isAuthorized("essentials.teleport.cooldown.bypass")) {
                throw new Exception(Util.format("timeBeforeTeleport", Util.formatDateDiff(cooldownTime.getTimeInMillis())));
            }
        }
        if (!check) {
            this.user.setLastTeleportTimestamp(now.getTimeInMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean notifyUser) {
        if (this.teleTimer == -1) {
            return;
        }
        try {
            this.user.getServer().getScheduler().cancelTask(this.teleTimer);
            if (notifyUser) {
                this.user.sendMessage(Util.i18n("pendingTeleportCancelled"));
            }
        }
        finally {
            this.teleTimer = -1;
        }
    }

    public void cancel() {
        this.cancel(false);
    }

    public void teleport(Location loc, String name) throws Exception {
        this.teleport(new Target(loc), name);
    }

    public void teleport(Entity entity, String name) throws Exception {
        this.teleport(new Target(entity), name);
    }

    private void teleport(Target target, String chargeFor) throws Exception {
        double delay = this.ess.getSettings().getTeleportDelay();
        this.cooldown(true);
        if (delay <= 0.0 || this.user.isAuthorized("essentials.teleport.timer.bypass")) {
            this.now(target);
            if (chargeFor != null) {
                this.user.charge(chargeFor);
            }
            return;
        }
        this.cancel();
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).add(13, (int)delay);
        ((Calendar)c).add(14, (int)(delay * 1000.0 % 1000.0));
        this.user.sendMessage(Util.format("dontMoveMessage", Util.formatDateDiff(c.getTimeInMillis())));
        this.initTimer((long)(delay * 1000.0), target, chargeFor);
        this.teleTimer = this.user.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Essentials.getStatic(), (Runnable)this, 10L, 10L);
    }

    private void now(Target target) throws Exception {
        this.cancel();
        this.user.setLastLocation();
        this.user.getBase().teleport(Util.getSafeDestination(target.getLocation()));
    }

    public void now(Location loc) throws Exception {
        this.now(new Target(loc));
    }

    public void now(Entity entity) throws Exception {
        this.now(new Target(entity));
    }

    public void back(String chargeFor) throws Exception {
        this.teleport(new Target(this.user.getLastLocation()), chargeFor);
    }

    public void back() throws Exception {
        this.back(null);
    }

    public void home(String chargeFor) throws Exception {
        this.home(this.user, chargeFor);
    }

    public void home(User user, String chargeFor) throws Exception {
        Location loc = user.getHome();
        if (loc == null) {
            if (this.ess.getSettings().spawnIfNoHome()) {
                this.respawn(Essentials.getSpawn(), chargeFor);
            } else {
                throw new Exception(user == this.user ? Util.i18n("noHomeSet") : Util.i18n("noHomeSetPlayer"));
            }
        }
        this.teleport(new Target(loc), chargeFor);
    }

    private static class Target {
        private Location location = null;
        private Entity entity = null;

        public Target(Location location) {
            this.location = location;
        }

        public Target(Entity entity) {
            this.entity = entity;
        }

        public Location getLocation() {
            if (this.entity != null) {
                return this.entity.getLocation();
            }
            return this.location;
        }
    }
}

