/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Warps
implements IConf {
    private static final Logger logger = Logger.getLogger("Minecraft");
    Map<StringIgnoreCase, EssentialsConf> warpPoints = new HashMap<StringIgnoreCase, EssentialsConf>();
    File warpsFolder;
    Server server;

    public Warps(Server server, File dataFolder) {
        this.server = server;
        this.warpsFolder = new File(dataFolder, "warps");
        if (!this.warpsFolder.exists()) {
            this.warpsFolder.mkdirs();
        }
        this.reloadConfig();
    }

    public boolean isEmpty() {
        return this.warpPoints.isEmpty();
    }

    public Iterable<String> getWarpNames() {
        ArrayList<String> keys = new ArrayList<String>();
        for (StringIgnoreCase stringIgnoreCase : this.warpPoints.keySet()) {
            keys.add(stringIgnoreCase.string);
        }
        Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
        return keys;
    }

    public Location getWarp(String warp) throws Exception {
        EssentialsConf conf = this.warpPoints.get(new StringIgnoreCase(warp));
        if (conf == null) {
            throw new Exception(Util.i18n("warpNotExist"));
        }
        return conf.getLocation(null, this.server);
    }

    public void setWarp(String name, Location loc) throws Exception {
        String filename = Util.sanitizeFileName(name);
        EssentialsConf conf = this.warpPoints.get(new StringIgnoreCase(name));
        if (conf == null) {
            File confFile = new File(this.warpsFolder, filename + ".yml");
            if (confFile.exists()) {
                throw new Exception(Util.i18n("similarWarpExist"));
            }
            conf = new EssentialsConf(confFile);
            this.warpPoints.put(new StringIgnoreCase(name), conf);
        }
        conf.setProperty(null, loc);
        conf.setProperty("name", name);
        conf.save();
    }

    public void delWarp(String name) throws Exception {
        EssentialsConf conf = this.warpPoints.get(new StringIgnoreCase(name));
        if (conf == null) {
            throw new Exception(Util.i18n("warpNotExist"));
        }
        if (!conf.getFile().delete()) {
            throw new Exception(Util.i18n("warpDeleteError"));
        }
        this.warpPoints.remove(new StringIgnoreCase(name));
    }

    @Override
    public final void reloadConfig() {
        this.warpPoints.clear();
        File[] listOfFiles = this.warpsFolder.listFiles();
        if (listOfFiles.length >= 1) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String filename = listOfFiles[i].getName();
                if (!listOfFiles[i].isFile() || !filename.endsWith(".yml")) continue;
                EssentialsConf conf = new EssentialsConf(listOfFiles[i]);
                conf.load();
                String name = conf.getString("name");
                if (name == null) continue;
                this.warpPoints.put(new StringIgnoreCase(name), conf);
            }
        }
    }

    private class StringIgnoreCase {
        String string;

        public StringIgnoreCase(String string) {
            this.string = string;
        }

        public int hashCode() {
            return this.string.toLowerCase().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof String) {
                return this.string.equalsIgnoreCase((String)o);
            }
            if (o instanceof StringIgnoreCase) {
                return this.string.equalsIgnoreCase(((StringIgnoreCase)o).string);
            }
            return false;
        }
    }
}

