/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.commands.EssentialsCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;

public class Commandinfo
extends EssentialsCommand {
    public Commandinfo() {
        super("info");
    }

    protected void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        int chapterstart;
        String line;
        int chapterend;
        String pageStr = args.length > 0 ? args[0].trim() : null;
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> chapters = new ArrayList<String>();
        HashMap<String, Integer> bookmarks = new HashMap<String, Integer>();
        File file = new File(this.ess.getDataFolder(), "info.txt");
        if (file.exists()) {
            BufferedReader rx = new BufferedReader(new FileReader(file));
            int i = 0;
            String l = null;
            while (rx.ready() && (l = rx.readLine()) != null) {
                if (l.startsWith("#")) {
                    bookmarks.put(l.substring(1).toLowerCase(), i);
                    chapters.add(l.substring(1));
                }
                lines.add(l.replace('&', '\u00a7'));
                ++i;
            }
        } else {
            sender.sendMessage("File info.txt does not exists.");
            return;
        }
        if (bookmarks.isEmpty()) {
            int page = 1;
            try {
                page = Integer.parseInt(pageStr);
            }
            catch (Exception ex) {
                page = 1;
            }
            int start = (page - 1) * 9;
            int pages = lines.size() / 9 + (lines.size() % 9 > 0 ? 1 : 0);
            this.charge(sender);
            sender.sendMessage("Page \u00a7c" + page + "\u00a7f of \u00a7c" + pages + "\u00a7f:");
            for (int i = start; i < lines.size() && i < start + 9; ++i) {
                sender.sendMessage((String)lines.get(i));
            }
            return;
        }
        if (pageStr == null || pageStr.isEmpty() || pageStr.matches("[0-9]+")) {
            String line2;
            int end;
            if (((String)lines.get(0)).startsWith("#")) {
                sender.sendMessage("Select chapter:");
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (String string : chapters) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append(string);
                }
                sender.sendMessage(sb.toString());
                return;
            }
            int page = 1;
            try {
                page = Integer.parseInt(pageStr);
            }
            catch (Exception ex) {
                page = 1;
            }
            int start = (page - 1) * 9;
            for (end = 0; end < lines.size() && !(line2 = (String)lines.get(end)).startsWith("#"); ++end) {
            }
            int pages = end / 9 + (end % 9 > 0 ? 1 : 0);
            this.charge(sender);
            sender.sendMessage("Page \u00a7c" + page + "\u00a7f of \u00a7c" + pages + "\u00a7f:");
            for (int i = start; i < end && i < start + 9; ++i) {
                sender.sendMessage((String)lines.get(i));
            }
            return;
        }
        int chapterpage = 0;
        if (args.length >= 2) {
            try {
                chapterpage = Integer.parseInt(args[1]) - 1;
            }
            catch (Exception ex) {
                chapterpage = 0;
            }
        }
        if (!bookmarks.containsKey(pageStr.toLowerCase())) {
            sender.sendMessage("Unknown chapter.");
            return;
        }
        for (chapterend = chapterstart = (Integer)bookmarks.get(pageStr.toLowerCase()) + 1; chapterend < lines.size() && !(line = (String)lines.get(chapterend)).startsWith("#"); ++chapterend) {
        }
        int start = chapterstart + chapterpage * 9;
        int page = chapterpage + 1;
        int pages = (chapterend - chapterstart) / 9 + ((chapterend - chapterstart) % 9 > 0 ? 1 : 0);
        this.charge(sender);
        sender.sendMessage("Chapter " + pageStr + ", page \u00a7c" + page + "\u00a7f of \u00a7c" + pages + "\u00a7f:");
        for (int i = start; i < chapterend && i < start + 9; ++i) {
            sender.sendMessage((String)lines.get(i));
        }
    }
}

