/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager;

import be.Balor.Manager.ExtendedConfiguration;
import java.util.Map;

public class LocaleManager {
    private static LocaleManager instance = null;
    private ExtendedConfiguration localeFile;
    private boolean noMsg = false;

    public static LocaleManager getInstance() {
        if (instance == null) {
            instance = new LocaleManager();
        }
        return instance;
    }

    public void setNoMsg(boolean noMsg) {
        this.noMsg = noMsg;
    }

    public void setLocaleFile(String fileName) {
        this.localeFile = new ExtendedConfiguration(fileName, "locales");
    }

    public void save() {
        this.localeFile.save();
    }

    public void addLocale(String key, String value) {
        this.localeFile.addProperty(key, value);
    }

    public void addLocale(String key, String value, boolean override) {
        this.localeFile.addProperty(key, value, override);
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, Map<String, String> values) {
        if (this.noMsg) {
            return null;
        }
        String locale = this.localeFile.getString(key);
        if (locale != null && values != null) {
            for (String toReplace : values.keySet()) {
                locale = locale.replaceAll("%" + toReplace, values.get(toReplace));
            }
        }
        return locale;
    }

    public String get(String key, String alias, String replaceBy) {
        if (this.noMsg) {
            return null;
        }
        String locale = this.localeFile.getString(key);
        if (locale != null && alias != null) {
            locale = locale.replaceAll("%" + alias, replaceBy);
        }
        return locale;
    }
}

