/*
 * Decompiled with CFR 0.152.
 */
package belgium.Balor.Workers;

import be.Balor.Tools.Utils;
import belgium.Balor.Workers.InvisibleWorker;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class AFKWorker {
    private ConcurrentMap<Player, Long> playerTimeStamp;
    private ConcurrentMap<Player, Object> playersAfk = new MapMaker().makeMap();
    private int afkTime = 60000;
    private int kickTime = 180000;
    private AfkChecker afkChecker = new AfkChecker();
    private KickChecker kickChecker = new KickChecker();
    private static AFKWorker instance;

    private AFKWorker() {
    }

    public static AFKWorker getInstance() {
        if (instance == null) {
            instance = new AFKWorker();
        }
        return instance;
    }

    public static void killInstance() {
        instance = null;
    }

    public AfkChecker getAfkChecker() {
        return this.afkChecker;
    }

    public KickChecker getKickChecker() {
        return this.kickChecker;
    }

    public void setAfkTime(int afkTime) {
        if (afkTime > 0) {
            this.afkTime = afkTime * 1000;
        }
    }

    public void setKickTime(int kickTime) {
        if (this.afkTime > 0) {
            this.kickTime = kickTime * 1000 * 60;
        }
    }

    public void setExpiration(long exp) {
        this.playerTimeStamp = new MapMaker().expiration(exp, TimeUnit.MINUTES).makeMap();
    }

    public void updateTimeStamp(Player player) {
        this.playerTimeStamp.put(player, System.currentTimeMillis());
    }

    public void removePlayer(Player player) {
        this.playerTimeStamp.remove(player);
        this.playersAfk.remove(player);
    }

    public void setAfk(Player p) {
        this.setAfk(p, null);
    }

    public void setAfk(Player p, String msg) {
        String afkString;
        if (!InvisibleWorker.getInstance().hasInvisiblePowers(p.getName()) && (afkString = Utils.I18n("afk", "player", p.getName())) != null) {
            p.getServer().broadcastMessage(afkString);
        }
        if (msg == null || msg != null && msg.isEmpty()) {
            this.playersAfk.put(p, System.currentTimeMillis());
        } else {
            this.playersAfk.put(p, msg);
        }
        p.setSleepingIgnored(true);
    }

    public void sendAfkMessage(Player sender, Player buddy) {
        Object obj = this.playersAfk.get(buddy);
        if (obj != null) {
            Utils.sI18n((CommandSender)sender, "noteAfk", "player", buddy.getName());
            if (obj instanceof String) {
                sender.sendMessage((String)obj);
            } else if (obj instanceof Long) {
                Long[] time = Utils.getElapsedTime((Long)obj);
                Utils.sI18n((CommandSender)sender, "idleTime", "mins", time[2].toString());
            }
        }
    }

    public void setOnline(Player p) {
        String online;
        if (!InvisibleWorker.getInstance().hasInvisiblePowers(p.getName()) && (online = Utils.I18n("online", "player", p.getName())) != null) {
            p.getServer().broadcastMessage(online);
        }
        p.setSleepingIgnored(false);
        this.playersAfk.remove(p);
    }

    public boolean isAfk(Player p) {
        return this.playersAfk.containsKey(p);
    }

    private class KickChecker
    implements Runnable {
        private KickChecker() {
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            for (Player p : AFKWorker.this.playersAfk.keySet()) {
                if (now - (Long)AFKWorker.this.playerTimeStamp.get(p) < (long)AFKWorker.this.kickTime) continue;
                p.kickPlayer(Utils.I18n("afkKick"));
                AFKWorker.this.playersAfk.remove(p);
                AFKWorker.this.playerTimeStamp.remove(p);
            }
        }
    }

    private class AfkChecker
    implements Runnable {
        private AfkChecker() {
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            for (Player p : Utils.getOnlinePlayers()) {
                if (!AFKWorker.this.playerTimeStamp.containsKey(p) || AFKWorker.this.playersAfk.containsKey(p) || now - (Long)AFKWorker.this.playerTimeStamp.get(p) < (long)AFKWorker.this.afkTime) continue;
                AFKWorker.this.setAfk(p);
            }
        }
    }
}

