/*
 * Decompiled with CFR 0.152.
 */
package belgium.Balor.Workers;

import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.UpdateInvisible;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import com.google.common.collect.MapMaker;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet20NamedEntitySpawn;
import net.minecraft.server.Packet29DestroyEntity;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class InvisibleWorker {
    protected static InvisibleWorker instance = null;
    private ConcurrentMap<String, Integer> invisblesWithTaskIds = new MapMaker().makeMap();
    private double maxRange = 262144.0;
    private int tickCheck = 400;

    protected InvisibleWorker() {
    }

    public static InvisibleWorker getInstance() {
        if (instance == null) {
            instance = new InvisibleWorker();
        }
        return instance;
    }

    public static void killInstance() {
        instance = null;
    }

    public void setMaxRange(long maxRange) {
        this.maxRange = maxRange ^ 2L;
    }

    public void setTickCheck(int tickCheck) {
        this.tickCheck = tickCheck * 20;
    }

    public LinkedList<Player> getAllInvisiblePlayers() {
        LinkedList<Player> result = new LinkedList<Player>();
        for (String p : this.invisblesWithTaskIds.keySet()) {
            result.add(AdminCmd.getBukkitServer().getPlayer(p));
        }
        return result;
    }

    public void reappear(final Player toReappear) {
        String name = toReappear.getName();
        if (this.invisblesWithTaskIds.containsKey(name)) {
            AdminCmd.getBukkitServer().getScheduler().cancelTask(((Integer)this.invisblesWithTaskIds.get(name)).intValue());
            this.invisblesWithTaskIds.remove(name);
            AdminCmd.getBukkitServer().getScheduler().scheduleAsyncDelayedTask((Plugin)ACHelper.getInstance().getPluginInstance(), new Runnable(){

                @Override
                public void run() {
                    for (Player p : Utils.getOnlinePlayers()) {
                        InvisibleWorker.this.uninvisible(toReappear, p);
                    }
                }
            });
            if (((Boolean)ACHelper.getInstance().getConfValue("fakeQuitWhenInvisible")).booleanValue()) {
                toReappear.getServer().broadcastMessage(ChatColor.YELLOW + name + " joined the game.");
            }
        }
    }

    public void invisible(Player hide, Player hideFrom) {
        if (hide == null) {
            return;
        }
        if (hideFrom == null) {
            return;
        }
        if (PermissionManager.hasPerm((CommandSender)hideFrom, "admincmd.invisible.cansee", false)) {
            return;
        }
        if (hide.getName().equals(hideFrom.getName())) {
            return;
        }
        if (Utils.getDistanceSquared(hide, hideFrom) > this.maxRange) {
            return;
        }
        ((CraftPlayer)hideFrom).getHandle().netServerHandler.sendPacket((Packet)new Packet29DestroyEntity(hide.getEntityId()));
    }

    private void uninvisible(Player unHide, Player unHideFrom) {
        if (unHide.equals(unHideFrom)) {
            return;
        }
        if (Utils.getDistanceSquared(unHide, unHideFrom) > this.maxRange) {
            return;
        }
        if (PermissionManager.hasPerm((CommandSender)unHide, "admincmd.invisible.cansee", false)) {
            return;
        }
        ((CraftPlayer)unHideFrom).getHandle().netServerHandler.sendPacket((Packet)new Packet29DestroyEntity(unHide.getEntityId()));
        ((CraftPlayer)unHideFrom).getHandle().netServerHandler.sendPacket((Packet)new Packet20NamedEntitySpawn((EntityHuman)((CraftPlayer)unHide).getHandle()));
    }

    public boolean hasInvisiblePowers(String player) {
        return this.invisblesWithTaskIds.containsKey(player);
    }

    public void vanish(Player toVanish) {
        String name = toVanish.getName();
        AdminCmd.getBukkitServer().getScheduler().scheduleAsyncDelayedTask((Plugin)ACHelper.getInstance().getPluginInstance(), (Runnable)new UpdateInvisible(toVanish));
        if (!this.invisblesWithTaskIds.containsKey(name)) {
            this.invisblesWithTaskIds.put(name, AdminCmd.getBukkitServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)ACHelper.getInstance().getPluginInstance(), (Runnable)new UpdateInvisible(toVanish), (long)(this.tickCheck / 2), (long)this.tickCheck));
        }
        if (((Boolean)ACHelper.getInstance().getConfValue("fakeQuitWhenInvisible")).booleanValue()) {
            toVanish.getServer().broadcastMessage(ChatColor.YELLOW + name + " left the game.");
        }
    }

    public int nbInvisibles() {
        return this.invisblesWithTaskIds.size();
    }
}

