/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.utils;

import java.util.ArrayList;
import net.minecraft.server.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.craftbukkit.CraftChunk;

public class BlockUtils {
    public static boolean isInRange(Location otherLoc, Location baseLoc, int range) {
        return otherLoc.getBlockX() >= baseLoc.getBlockX() - range && otherLoc.getBlockX() <= baseLoc.getBlockX() + range && otherLoc.getBlockZ() >= baseLoc.getBlockZ() - range && otherLoc.getBlockZ() <= baseLoc.getBlockZ() + range && otherLoc.getBlockY() >= baseLoc.getBlockY() - range && otherLoc.getBlockY() <= baseLoc.getBlockY() + range;
    }

    public static void setLightLevel(Block block, int level) {
        Chunk c = ((CraftChunk)block.getChunk()).getHandle();
        int x = block.getX() - 16 * block.getChunk().getX();
        int z = block.getZ() - 16 * block.getChunk().getZ();
        if (block.getType().equals((Object)Material.AIR)) {
            c.g.a(x, block.getY(), z, level);
        } else {
            c.g.a(x, block.getY(), z, level);
        }
    }

    public static Chest isDoubleChest(Block chestBlock) {
        if (chestBlock.getTypeId() != Material.CHEST.getId()) {
            return null;
        }
        Block[] neighbours = BlockUtils.getDirectNeighbours(chestBlock, false);
        int i = 0;
        while (i < neighbours.length) {
            if (neighbours[i].getTypeId() == Material.CHEST.getId()) {
                return (Chest)neighbours[i].getState();
            }
            ++i;
        }
        return null;
    }

    public static boolean isValidItemID(int ID) {
        Material[] all = Material.values();
        int i = 0;
        while (i < all.length) {
            if (all[i].getId() == ID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidBlock(int ID) {
        boolean f = false;
        Material[] all = Material.values();
        int i = 0;
        while (i < all.length) {
            if (all[i].getId() == ID) {
                f = true;
                break;
            }
            ++i;
        }
        return f && ID > -1 && ID < 97;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValidBlock(String name) {
        try {
            return BlockUtils.isValidBlock(Integer.valueOf(name));
        }
        catch (Exception e) {
            f = -1;
            all = Material.values();
            i = 0;
            ** while (i < all.length)
        }
lbl-1000:
        // 1 sources

        {
            if (all[i].name().equalsIgnoreCase(name)) {
                f = i;
                break;
            }
            ++i;
            continue;
        }
lbl13:
        // 2 sources

        return f > -1 && f < 97;
    }

    public static int getItemIDFromName(String name) {
        Material[] all = Material.values();
        if (name == null) {
            return -1;
        }
        try {
            String[] args = name.split(":");
            int i = 0;
            while (i < all.length) {
                if (all[i].name().equalsIgnoreCase(args[0])) {
                    if (all[i].getId() == Material.WOOL.getId() && args.length > 1 && Integer.valueOf(args[1]) >= 0 && Integer.valueOf(args[1]) <= 15) {
                        return all[i].getId();
                    }
                    if (all[i].getId() == Material.INK_SACK.getId() && args.length > 1) {
                        if (Integer.valueOf(args[1]) >= 0 && Integer.valueOf(args[1]) <= 15) {
                            return all[i].getId();
                        }
                    } else if (all[i].getId() == Material.STEP.getId() && args.length > 1) {
                        if (Integer.valueOf(args[1]) >= 0 && Integer.valueOf(args[1]) <= 3) {
                            return all[i].getId();
                        }
                    } else if (all[i].getId() == Material.LOG.getId() && args.length > 1) {
                        if (Integer.valueOf(args[1]) >= 0 && Integer.valueOf(args[1]) <= 2) {
                            return all[i].getId();
                        }
                    } else if (all[i].getId() == Material.SAPLING.getId() && args.length > 1) {
                        if (Integer.valueOf(args[1]) >= 0 && Integer.valueOf(args[1]) <= 2) {
                            return all[i].getId();
                        }
                    } else if (all[i].getId() == Material.COAL.getId() && args.length > 1) {
                        if (Integer.valueOf(args[1]) >= 0 && Integer.valueOf(args[1]) <= 1) {
                            return all[i].getId();
                        }
                    } else {
                        return all[i].getId();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    public static boolean canPassThrough(int id) {
        return id == Material.AIR.getId() || id == Material.SAPLING.getId() || id == Material.YELLOW_FLOWER.getId() || id == Material.RED_ROSE.getId() || id == Material.BROWN_MUSHROOM.getId() || id == Material.RED_MUSHROOM.getId() || id == Material.TORCH.getId() || id == Material.FIRE.getId() || id == Material.REDSTONE_WIRE.getId() || id == Material.CROPS.getId() || id == Material.SIGN_POST.getId() || id == Material.LADDER.getId() || id == Material.RAILS.getId() || id == Material.DETECTOR_RAIL.getId() || id == Material.POWERED_RAIL.getId() || id == Material.WALL_SIGN.getId() || id == Material.LEVER.getId() || id == Material.STONE_PLATE.getId() || id == Material.WOOD_PLATE.getId() || id == Material.REDSTONE_TORCH_OFF.getId() || id == Material.REDSTONE_TORCH_ON.getId() || id == Material.STONE_BUTTON.getId() || id == Material.SNOW.getId() || id == Material.SUGAR_CANE.getId() || id == Material.PORTAL.getId() || id == Material.DIODE.getId() || id == Material.TRAP_DOOR.getId() || id == Material.WEB.getId() || id == Material.LONG_GRASS.getId() || id == Material.DEAD_BUSH.getId() || id == Material.WHEAT.getId();
    }

    public static boolean LocationEquals(Location loc1, Location loc2) {
        return loc1.getBlockX() == loc2.getBlockX() && loc1.getBlockY() == loc2.getBlockY() && loc1.getBlockZ() == loc2.getBlockZ() && loc1.getWorld().getName().equalsIgnoreCase(loc2.getWorld().getName());
    }

    public static boolean isComplexBlock(int id) {
        return id == Material.WALL_SIGN.getId() || id == Material.SIGN_POST.getId() || id == Material.TORCH.getId() || id == Material.REDSTONE_TORCH_ON.getId() || id == Material.REDSTONE_TORCH_OFF.getId() || id == Material.REDSTONE_WIRE.getId() || id == Material.RED_ROSE.getId() || id == Material.YELLOW_FLOWER.getId() || id == Material.BROWN_MUSHROOM.getId() || id == Material.RED_MUSHROOM.getId() || id == Material.LEVER.getId() || id == Material.RAILS.getId() || id == Material.WOODEN_DOOR.getId() || id == Material.IRON_DOOR.getId() || id == Material.WOOD_DOOR.getId() || id == Material.IRON_DOOR_BLOCK.getId() || id == Material.BED_BLOCK.getId() || id == Material.BED.getId() || id == Material.WOODEN_DOOR.getId() || id == Material.SEEDS.getId() || id == Material.CROPS.getId() || id == Material.STONE_PLATE.getId() || id == Material.WOOD_PLATE.getId() || id == Material.FENCE.getId() || id == Material.CACTUS.getId() || id == Material.STONE_BUTTON.getId() || id == Material.DIODE_BLOCK_OFF.getId() || id == Material.DIODE_BLOCK_ON.getId() || id == Material.CAKE_BLOCK.getId() || id == Material.TRAP_DOOR.getId() || id == Material.DEAD_BUSH.getId() || id == Material.LONG_GRASS.getId();
    }

    public static boolean isComplexBlock(Block block) {
        return BlockUtils.isComplexBlock(block.getTypeId());
    }

    public static ArrayList<Object> ListContainsBlock(ArrayList<Block> list, Block block) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).equals(block)) {
                result.add(true);
                result.add(block);
                break;
            }
            ++i;
        }
        if (result.size() == 0) {
            result.add(false);
            result.add(null);
        }
        return result;
    }

    public static ArrayList<Object> ListContainsBlockType(ArrayList<Block> list, Material mat) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).getType().equals((Object)mat)) {
                result.add(true);
                result.add(list.get(i));
                break;
            }
            ++i;
        }
        if (result.size() == 0) {
            result.add(false);
            result.add(null);
        }
        return result;
    }

    public static ArrayList<Object> ListContainsBlockTypeID(ArrayList<Block> list, int blockID) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).getTypeId() == blockID) {
                result.add(true);
                result.add(list.get(i));
                break;
            }
            ++i;
        }
        if (result.size() == 0) {
            result.add(false);
            result.add(null);
        }
        return result;
    }

    public static ArrayList<Block> getNeighbourBlocks(Block block) {
        ArrayList<Block> list = new ArrayList<Block>();
        World w = block.getWorld();
        int x = block.getX();
        int z = block.getZ();
        int y = block.getY();
        list.add(w.getBlockAt(x - 1, y, z));
        list.add(w.getBlockAt(x + 1, y, z));
        list.add(w.getBlockAt(x, y, z - 1));
        list.add(w.getBlockAt(x, y, z + 1));
        list.add(w.getBlockAt(x, y + 1, z));
        list.add(w.getBlockAt(x, y - 1, z));
        list.add(w.getBlockAt(x - 1, y, z - 1));
        list.add(w.getBlockAt(x + 1, y, z + 1));
        list.add(w.getBlockAt(x - 1, y, z + 1));
        list.add(w.getBlockAt(x + 1, y, z - 1));
        list.add(w.getBlockAt(x - 1, y + 1, z));
        list.add(w.getBlockAt(x + 1, y + 1, z));
        list.add(w.getBlockAt(x, y + 1, z - 1));
        list.add(w.getBlockAt(x, y + 1, z + 1));
        list.add(w.getBlockAt(x - 1, y - 1, z));
        list.add(w.getBlockAt(x + 1, y - 1, z));
        list.add(w.getBlockAt(x, y - 1, z - 1));
        list.add(w.getBlockAt(x, y - 1, z + 1));
        list.add(w.getBlockAt(x - 1, y + 1, z - 1));
        list.add(w.getBlockAt(x + 1, y + 1, z + 1));
        list.add(w.getBlockAt(x - 1, y + 1, z + 1));
        list.add(w.getBlockAt(x + 1, y + 1, z - 1));
        list.add(w.getBlockAt(x - 1, y - 1, z - 1));
        list.add(w.getBlockAt(x + 1, y - 1, z + 1));
        list.add(w.getBlockAt(x - 1, y - 1, z + 1));
        list.add(w.getBlockAt(x + 1, y - 1, z - 1));
        return list;
    }

    public static Block[] getDirectNeighbours(Block block, boolean UpAndDown) {
        Block[] result = new Block[4];
        if (UpAndDown) {
            result = new Block[6];
        }
        result[0] = block.getRelative(1, 0, 0);
        result[1] = block.getRelative(-1, 0, 0);
        result[2] = block.getRelative(0, 0, 1);
        result[3] = block.getRelative(0, 0, -1);
        if (UpAndDown) {
            result[4] = block.getRelative(0, 1, 0);
            result[5] = block.getRelative(0, -1, 0);
        }
        return result;
    }

    public static boolean isLow(Location pos) {
        return !BlockUtils.isPowered(pos);
    }

    public static boolean isPowered(Location pos) {
        if (pos.getBlock().getType().equals((Object)Material.REDSTONE_WIRE)) {
            return pos.getBlock().getData() > 0;
        }
        if (pos.getBlock().getType().equals((Object)Material.LEVER)) {
            return pos.getBlock().getData() > 10;
        }
        if (pos.getBlock().getType().equals((Object)Material.WOOD_PLATE) || pos.getBlock().getType().equals((Object)Material.STONE_PLATE)) {
            return pos.getBlock().getData() > 0;
        }
        if (pos.getBlock().getType().equals((Object)Material.DIODE_BLOCK_ON)) {
            return true;
        }
        return pos.getBlock().getType().equals((Object)Material.REDSTONE_TORCH_ON);
    }
}

